<?php

use Illuminate\Support\Facades\Route;

Route::prefix('admin/guru')->group(function () {

    Route::get('/', 'Admin\Stakeholder\GuruController@index')->name('guru');
    Route::get('/create', 'Admin\Stakeholder\GuruController@create');
    Route::post('/store', 'Admin\Stakeholder\GuruController@store');
    Route::get('/{dataId?}/edit', 'Admin\Stakeholder\GuruController@edit');
    Route::get('/update-status/{dataId?}', 'Admin\Stakeholder\GuruController@updateStatus');
    Route::get('/delete/{dataId?}', 'Admin\Stakeholder\GuruController@delete');
    Route::put('/update/{dataId?}', 'Admin\Stakeholder\GuruController@update');

    Route::get('/wali-kelas', 'Admin\Stakeholder\SekolahWaliController@index')->name('wali.kelas');
    Route::get('/wali-kelas/create', 'Admin\Stakeholder\SekolahWaliController@create');
    Route::get('/wali-kelas/get-non-wali', 'Admin\Stakeholder\SekolahWaliController@getNonWali');
    Route::post('/wali-kelas/store', 'Admin\Stakeholder\SekolahWaliController@store');
    Route::get('/wali-kelas/{dataId?}', 'Admin\Stakeholder\SekolahWaliController@show');
    Route::get('/wali-kelas/{dataId?}/edit', 'Admin\Stakeholder\SekolahWaliController@edit');
    Route::put('/wali-kelas/update/{dataId?}', 'Admin\Stakeholder\SekolahWaliController@update');
    Route::delete('/wali-kelas/delete/{dataId?}', 'Admin\Stakeholder\SekolahWaliController@destroy');

    Route::get('/kepala-sekolah', 'Admin\Stakeholder\KepsekController@index')->name('kepala.sekolah');
    Route::get('/kepala-sekolah/create', 'Admin\Stakeholder\KepsekController@create');
    Route::post('/kepala-sekolah/store', 'Admin\Stakeholder\KepsekController@store');
    Route::get('/kepala-sekolah/{dataId?}/edit', 'Admin\Stakeholder\KepsekController@edit');
    Route::put('/kepala-sekolah/update/{dataId?}', 'Admin\Stakeholder\KepsekController@update');

    Route::get('/waka-kurikulum', 'Admin\Stakeholder\WakaKurikulumController@index')->name('waka.kurikulum');
    Route::get('/waka-kurikulum/create', 'Admin\Stakeholder\WakaKurikulumController@create');
    Route::post('/waka-kurikulum/store', 'Admin\Stakeholder\WakaKurikulumController@store');
    Route::get('/waka-kurikulum/{dataId?}/edit', 'Admin\Stakeholder\WakaKurikulumController@edit');
    Route::put('/waka-kurikulum/update/{dataId?}', 'Admin\Stakeholder\WakaKurikulumController@update');

    Route::get('/waka-kesiswaan', 'Admin\Stakeholder\WakaKesiswaanController@index')->name('waka.kesiswaan');
    Route::get('/waka-kesiswaan/create', 'Admin\Stakeholder\WakaKesiswaanController@create');
    Route::post('/waka-kesiswaan/store', 'Admin\Stakeholder\WakaKesiswaanController@store');
    Route::get('/waka-kesiswaan/{dataId?}/edit', 'Admin\Stakeholder\WakaKesiswaanController@edit');
    Route::put('/waka-kesiswaan/update/{dataId?}', 'Admin\Stakeholder\WakaKesiswaanController@update');

    Route::get('/guru-piket', 'Admin\Stakeholder\GuruPiketController@index')->name('guru.piket');
    Route::get('/guru-piket/create', 'Admin\Stakeholder\GuruPiketController@create');
    Route::post('/guru-piket/store', 'Admin\Stakeholder\GuruPiketController@store');
    Route::get('/guru-piket/{dataId?}/edit', 'Admin\Stakeholder\GuruPiketController@edit');
    Route::put('/guru-piket/update/{dataId?}', 'Admin\Stakeholder\GuruPiketController@update');

    Route::get('/konselor', 'Admin\Stakeholder\KonselorController@index')->name('konselor');
    Route::get('/konselor/create', 'Admin\Stakeholder\KonselorController@create');
    Route::post('/konselor/store', 'Admin\Stakeholder\KonselorController@store');
    Route::get('/konselor/{dataId?}/edit', 'Admin\Stakeholder\KonselorController@edit');
    Route::put('/konselor/update/{dataId?}', 'Admin\Stakeholder\KonselorController@update');
    Route::get('/konselor/setting-massal', 'Admin\Stakeholder\KonselorController@settingMassal');
    Route::post('/konselor/setting-massal-proses', 'Admin\Stakeholder\KonselorController@settingMassalProcess');

    Route::get('/{dataId?}', 'Admin\Stakeholder\GuruController@show');
});


Route::prefix('admin/akademik')->group(function () {

    Route::get('/absensi', 'Admin\Akademik\AbsensiController@index')->name('absensi');
    Route::get('/absensi/get-absensi/{dataId}', 'Admin\Akademik\AbsensiController@getAbsensi');
    Route::get('/absensi/create/{dataId}/{date}', 'Admin\Akademik\AbsensiController@create');
    Route::get('/absensi/get-absensi-form/{dataId}/{dataTanggal}', 'Admin\Akademik\AbsensiController@getAbsensiForm');
    Route::post('/absensi/store', 'Admin\Akademik\AbsensiController@store');
    Route::get('/absensi/{dataId?}/edit', 'Admin\Akademik\AbsensiController@edit');
    Route::put('/absensi/update/{dataId?}', 'Admin\Akademik\AbsensiController@update');
});

Route::prefix('/admin/tahun-ajaran')->group(function () {
    Route::get('/', 'Admin\Periode\PeriodeController@index')->name('tahun-ajaran');
    Route::get('/create', 'Admin\Periode\PeriodeController@create');
    Route::post('/store', 'Admin\Periode\PeriodeController@store');

    Route::get('/siswa', 'Admin\Periode\PeriodeSiswaKelasController@index')->name('tahun-ajaran.update.siswa');
    Route::put('/siswa/update/{dataId?}', 'Admin\Periode\PeriodeSiswaKelasController@update');
    Route::get('/siswa/{dataId?}', 'Admin\Periode\PeriodeSiswaKelasController@show');
});

Route::prefix('/admin/import-dapodik')->group(function () {
    Route::get('/guru', 'Admin\Import\ImportGuruDapodikController@index')->name('import-dapodik.guru');
    Route::get('/datatable', 'Admin\Import\ImportGuruDapodikController@datatable')->name('import-dapodik.gurutable');
    Route::get('/guru/create', 'Admin\Import\ImportGuruDapodikController@create');
    Route::post('/guru/store', 'Admin\Import\ImportGuruDapodikController@store');
    Route::post('/guru/migrate', 'Admin\Import\MigrasiDapodikController@migrasiGuru');

    Route::get('/siswa', 'Admin\Import\ImportSiswaDapodikController@index')->name('import-dapodik.siswa');
    Route::get('/siswa/create', 'Admin\Import\ImportSiswaDapodikController@create');
    Route::post('/siswa/store', 'Admin\Import\ImportSiswaDapodikController@store');
    Route::post('/siswa/migrate', 'Admin\Import\MigrasiDapodikController@migrasiSiswa');

    // Route::prefix('/siswa')->group(function () {
    //     Route::get('/', 'Admin\Import\ImportSiswaDapodikController@index')->name('siswa');
    //     Route::get('/create/{dataId?}', 'Admin\Import\ImportSiswaDapodikController@create');
    //     Route::post('/store', 'Admin\Import\ImportSiswaDapodikController@store');
    //     Route::get('/{dataId?}/edit', 'Admin\Import\ImportSiswaDapodikController@edit');
    //     Route::put('/update/{dataId?}', 'Admin\Import\ImportSiswaDapodikController@update');
    //     Route::delete('/delete/{dataId?}', 'Admin\Import\ImportSiswaDapodikController@delete');
    //     Route::get('/{dataId?}', 'Admin\Import\ImportSiswaDapodikController@show');
    // });
});


Route::prefix('/admin/import')->group(function () {

    // Route::get('/siswa', 'Admin\Import\ImportSiswaController@index')->name('import.siswa');
    // Route::get('/siswa/create', 'Admin\Import\ImportSiswaController@create');
    // Route::post('/siswa/store', 'Admin\Import\ImportSiswaController@store');

    Route::get('/guru', 'Admin\Import\ImportGuruController@index')->name('import.guru');
    Route::get('/guru/create', 'Admin\Import\ImportGuruController@create');
    Route::post('/guru/store', 'Admin\Import\ImportGuruController@store');
});
