<?php

use Illuminate\Support\Facades\Route;


Route::prefix('/admin/users')->group(function () {
    Route::get('/', 'Admin\UsersController@index')->name('users');
    Route::get('/create', 'Admin\UsersController@create');
    Route::post('/store', 'Admin\UsersController@store');
    Route::get('/{dataId?}/edit', 'Admin\UsersController@edit');
    Route::put('/update/{dataId?}', 'Admin\UsersController@update');
});

Route::prefix('admin/master')->group(function () {

    Route::get('/agama', 'Admin\Master\AgamaController@index')->name('agama');
    Route::get('/agama/create', 'Admin\Master\AgamaController@create');
    Route::post('/agama/store', 'Admin\Master\AgamaController@store');
    Route::get('/agama/{dataId?}/edit', 'Admin\Master\AgamaController@edit');
    Route::put('/agama/update/{dataId?}', 'Admin\Master\AgamaController@update');

    Route::get('/pekerjaan', 'Admin\Master\PekerjaanController@index')->name('pekerjaan');
    Route::get('/pekerjaan/create', 'Admin\Master\PekerjaanController@create');
    Route::post('/pekerjaan/store', 'Admin\Master\PekerjaanController@store');
    Route::get('/pekerjaan/{dataId?}/edit', 'Admin\Master\PekerjaanController@edit');
    Route::put('/pekerjaan/update/{dataId?}', 'Admin\Master\PekerjaanController@update');

    Route::get('/provinsi', 'Admin\Master\ProvinsiController@index')->name('provinsi');
    Route::get('/provinsi/create', 'Admin\Master\ProvinsiController@create');
    Route::post('/provinsi/store', 'Admin\Master\ProvinsiController@store');
    Route::get('/provinsi/{dataId?}/edit', 'Admin\Master\ProvinsiController@edit');
    Route::put('/provinsi/update/{dataId?}', 'Admin\Master\ProvinsiController@update');

    Route::get('/daerah', 'Admin\Master\DaerahController@index')->name('daerah');
    Route::get('/daerah/create', 'Admin\Master\DaerahController@create');
    Route::post('/daerah/store', 'Admin\Master\DaerahController@store');
    Route::get('/daerah/{dataId?}/edit', 'Admin\Master\DaerahController@edit');
    Route::put('/daerah/update/{dataId?}', 'Admin\Master\DaerahController@update');

    Route::get('/periode', 'Admin\Master\PeriodeController@index')->name('periode-admin');
    Route::get('/periode/create', 'Admin\Master\PeriodeController@create');
    Route::post('/periode/store', 'Admin\Master\PeriodeController@store');
    Route::get('/periode/{dataId?}/edit', 'Admin\Master\PeriodeController@edit');
    Route::put('/periode/update/{dataId?}', 'Admin\Master\PeriodeController@update');

    Route::get('/mapel-guru', 'Admin\Master\MapelGuruController@index')->name('mapel-guru-admin');
    Route::get('/mapel-guru/create', 'Admin\Master\MapelGuruController@create');
    Route::post('/mapel-guru/store', 'Admin\Master\MapelGuruController@store');
    Route::get('/mapel-guru/{dataId?}/edit', 'Admin\Master\MapelGuruController@edit');
    Route::put('/mapel-guru/update/{dataId?}', 'Admin\Master\MapelGuruController@update');
});

Route::prefix('admin/master/sekolah')->group(function () {

    Route::get('/', 'Admin\Perpus\SekolahController@index')->name('sekolah');
    Route::get('/create', 'Admin\Perpus\SekolahController@create');
    Route::post('/store', 'Admin\Perpus\SekolahController@store');
    Route::get('/{dataId?}', 'Admin\Perpus\SekolahController@show');
    Route::get('/{dataId?}/edit', 'Admin\Perpus\SekolahController@edit');
    Route::put('/update/{dataId?}', 'Admin\Perpus\SekolahController@update');

});

Route::prefix('admin/master/sekolah-request')->group(function () {

    Route::get('/', 'Admin\Perpus\SekolahRequestController@index')->name('sekolah-request');
    Route::get('/{dataId?}', 'Admin\Perpus\SekolahRequestController@show');
    Route::get('/{dataId?}/accept', 'Admin\Perpus\SekolahRequestController@accept');
    Route::get('/{dataId?}/decline', 'Admin\Perpus\SekolahRequestController@decline');

});

Route::prefix('/admin/import-sekolah')->group(function () {
    Route::get('/', 'Admin\Import\ImportSekolahController@index')->name('admin.import,sekolah');
    Route::get('/create', 'Admin\Import\ImportSekolahController@create');
    Route::post('/store', 'Admin\Import\ImportSekolahController@store');
});
