@extends($auth)

@section('title')
 {{ $title }} - Login
@endsection

@push('css')
@endpush

@section('content')
    <section>
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-12">
                    <div class="login-card">
                        <form action="{{ url('update-proses') }}" method="POST" class="theme-form login-form">
                            @csrf
                            @method('POST')

                            <div class="row">
                                <img class="img-fluid px-5" src="{{asset('assets/images/logo/sibiling-new-logo.png')}}" alt="sibiling">
                            </div>

                            <h4>Login</h4>

                            @if (session()->has('sukses'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('sukses') }}
                                </div>
                            @elseif (session()->has('gagal'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('gagal') }}
                                </div>
                            @endif

                            <h6>Update Password Anda !.</h6>
                            <div class="form-group">
                                <label>Password Lama</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="icon-lock"></i></span>
                                    <input required class="form-control @error('login.password') is-invalid @enderror" type="password" name="login[password]" placeholder="*********" />
                                    <div class="show-hide"><span class="show"> </span></div>
                                    @error('login.password')
                                        <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Password Baru</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="icon-lock"></i></span>
                                    <input required class="form-control @error('login.password_new') is-invalid @enderror" type="password" name="login[password_new]" placeholder="*********" />
                                    <div class="show-hide"><span class="show"> </span></div>
                                    @error('login.password_new')
                                        <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Ulangi Password Baru</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="icon-lock"></i></span>
                                    <input required class="form-control @error('login.password_verif') is-invalid @enderror" type="password" name="login[password_verif]" placeholder="*********" />
                                    <div class="show-hide"><span class="show"> </span></div>
                                    @error('login.password_verif')
                                        <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-group">
                                <button class="btn btn-primary btn-block" type="submit">Perbarui</button>
                            </div>
                            <p>Login Akun lain ?<a class="ms-2" href="{{ url('login') }}">Login</a></p>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
	
    @push('scripts')
    @endpush
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

@endsection