@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/select2.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Users</h3>
        @endslot
        <li class="breadcrumb-item">Users</li>
        <li class="breadcrumb-item active">Tambah</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-6">
                            <h5 class="card-title">{{ $page }}</h5>
                        </div>
                        <div class="col-lg-6">
                            <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">Kembali</a>
                        </div>
                    </div>
                </div>
                    <form action="{{ url($url) }}/store" method="POST">
                        @csrf
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Provinsi</label>
                                <select id="select-provinsi" class="form-select select2" name="idMProvinsi" aria-label="Default select example" required>
                                    <option value="">Pilihan Provinsi Sedang di Proses</option>
                                    {{-- @foreach ($provinsi as $r) 
                                        <option value="{{ $r->id }}">{{ $r->nama }}</option>
                                    @endforeach --}}
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Daerah</label>
                                <select id="select-daerah" class="form-select select2" name="idMDaerah" aria-label="Default select example" required>
                                    <option value="">Pilih Provinsi Terlebih Dahulu</option>
                                    {{-- @foreach ($sekolah as $r) 
                                        <option value="{{ $r->id }}">{{ $r->nama }}</option>
                                    @endforeach --}}
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Sekolah</label> 
                                <div class="row">
                                    <div class="col-lg-9">
                                        <select id="select-sekolah" class="form-select select2" name="idPSekolah" aria-label="Default select example" required>
                                            <option value="">Pilih Daerah Terlebih Dahulu</option>
                                            {{-- @foreach ($sekolah as $r) 
                                                <option value="{{ $r->id }}">{{ $r->nama }}</option>
                                            @endforeach --}}
                                        </select>
                                    </div>
                                    <div class="col-lg-3">
                                        <a href="{{ url('admin/master/sekolah/create') }}" class="btn btn-sm btn-primary">Tambah Sekolah</a>
                                    </div>
                                </div>
                            </div>
                            {{-- <div class="form-floating">
                                <input type="text" name="username" class="form-control @error('username') is-invalid @enderror" id="username" placeholder="Username" required value="{{ $user->username }}">
                                <label for="username">Username</label>
                                @error('username')
                                    <div class="invalid-feedback">
                                    {{ $message }}
                                    </div>
                                @enderror
                            </div> --}}
                            {{-- <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">NPSN</label>
                                <input name="username" class="form-control" type="text" placeholder="masukkan npsn">
                            </div> --}}
                            {{-- <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Password</label>
                                <input name="password" class="form-control" type="text" placeholder="Masukkan password">
                            </div> --}}
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Password</label>
                                <input name="password" class="form-control" type="text" placeholder="" disabled value="bkpeduli">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Role Pengguna</label>
                                <input name="role" class="form-control" type="text" placeholder="" disabled value="Admin Sekolah">
                            </div>
                            <div class="col-lg-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Aktif</label><br>
                                <input id="inline-1" name="status" type="checkbox" value="1" style="height: 20px; width: 20px;">
                            </div>
                        </div>
                        <div class="card-footer">
                            <input type="submit" class="btn btn-primary" value="Simpan">
                            <input type="reset" class="btn btn-secondary" value="Cancel">
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
        <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
        <script src="{{ asset('assets/js/select2/select2.full.min.js') }}"></script>
        <script src="{{ asset('assets/js/select2/select2-custom.js') }}"></script>
        <script>
            $(function() {
                let baseUrl     = '{{ url('') }}';

                $.getJSON(baseUrl+'/getAllProvinsi', (result) => {
                    if (result.error_code == '0') {
                        let opt = '<option value="">- Pilih -</option>';
                        $.each(result.data, function(i, item) {
                            opt += '<option value="'+item.id+'">'+item.nama+'</option>';
                        });
                        $("#select-provinsi").html(opt);
                    }else{
                        let opt = '<option value="">- Tidak Bisa -</option>';
                        $("#select-provinsi").html(opt);
                    }
                    $("#select-provinsi").select2({
                        placeholder: "Pilih Provinsi",
                    });
                });

                $('#select-provinsi').on('change', function() {
                    var val1 = this.value;
                    $.getJSON(baseUrl+'/getProvinsiDaerah/'+val1, (result) => {
                        if (result.error_code == '0') {
                            let opt = '<option value="">- Pilih Daerah -</option>';
                            // var dataSem = result.data;
                            // dataSem.sort(function(a, b){
                            //     return a.id_semester - b.id_semester;
                            // });
                            $.each(result.data, function(i, item) {
                                opt += '<option value="'+item.id+'">'+item.nama+'</option>';
                            });
                            $("#select-daerah").html(opt);
                        }else{
                            let opt = '<option value="">- Tidak Bisa -</option>';
                            $("#select-daerah").html(opt);
                        }
                        $("#select-daerah").select2({
                            placeholder: "Pilih Daerah",
                        });
                    });
                });

                $('#select-daerah').on('change', function() {
                    var val1 = this.value;
                    $.getJSON(baseUrl+'/getDaerahSekolah/'+val1, (result) => {
                        if (result.error_code == '0') {
                            let opt = '<option value="">- Pilih Sekolah -</option>';
                            // var dataSem = result.data;
                            // dataSem.sort(function(a, b){
                            //     return a.id_semester - b.id_semester;
                            // });
                            $.each(result.data, function(i, item) {
                                opt += '<option value="'+item.id+'">'+item.npsn+' - '+item.nama+'</option>';
                            });
                            $("#select-sekolah").html(opt);
                        }else{
                            let opt = '<option value="">- Tidak Bisa -</option>';
                            $("#select-sekolah").html(opt);
                        }
                        $("#select-sekolah").select2({
                            placeholder: "Pilih Sekolah",
                        });
                    });
                });

            });
        </script>

    @endpush

@endsection
