@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman</h3>
        @endslot
        <li class="breadcrumb-item">Halaman</li>
        <li class="breadcrumb-item active">List</li>
    @endcomponent

    <div class="container-fluid pt-4">
                        
        <div class="row justify-content-center">
            <div class="col-lg-10 col-sm-12">
                <div class="card border-top border-0 border-4 border-info">
                    <div class="card-header p-3">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">{{ $page }}</h5>
                            </div>
                            <div class="col-lg-6">
                                <a href="{{ url($url) }}/create" class="btn btn-sm btn-primary float-end">Ganti Waka Kurikulum</a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <table id="datatable" class="table text-center">
                            <tbody>
                            @if ($guru == null)
                                <tr>
                                    <td colspan="3" class="text-center">Waka Kurikulum Belum di Set</td>
                                </tr>
                            @else
                                @foreach ($guru as $p)
                                    <tr>
                                        <td class="text-sm-end"><b>Nama Waka Kurikulum</b></td>
                                        <td>:</td>
                                        <td class="text-sm-start"><b>{{ $p->nama }}</b></td>
                                    </tr>
                                    
                                    <tr>
                                        <td class="text-sm-end">NIP Waka Kurikulum</td>
                                        <td>:</td>
                                        <td class="text-sm-start">{{ $p->nip }} </td>
                                    </tr>
                                @endforeach
                            @endif
                            </tbody>
                        </table>  
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
        <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
    @endpush

@endsection



