@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman</h3>
        @endslot
        <li class="breadcrumb-item">Halaman</li>
        <li class="breadcrumb-item active">List</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <div class="container-fluid pt-4">
                                
                <div class="row justify-content-center">
                    <div class="col-lg-10 col-sm-12">
                        <div class="card border-top border-0 border-4 border-info">
                            <div class="card-header p-3">
                                <div class="row">
                                    <div class="col-lg-6">
                                        {{-- Kalo di laravel, ada fitur kurung kurawal 2 kali untuk echo --}}
                                        <h5 class="card-title">{{ $page }}</h5>
                                    </div>
                                    <div class="col-lg-6">
                                        {{-- karena pake route web resource, dibuat sama semua urlnya. Ini otomatis ke halaman form --}}
                                        <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">kembali</a>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body">
                                <table id="datatable" class="table text-center">
                                    <tbody>

                                        <tr>
                                            <td class="text-sm-end"><b>Nama Sekolah</b></td>
                                            <td>:</td>
                                            <td class="text-sm-start"><b>{{ $perpus_kelasKode->sekolah->nama}}</b></td>
                                        </tr>
                                        <tr>
                                            <td class="text-sm-end">Kelas</td>
                                            <td>:</td>
                                            <td class="text-sm-start">{{ $perpus_kelasKode->kelas->nama.' '.$perpus_kelasKode->kelas->jurusan->nama.' '.$perpus_kelasKode->nama }}</td>
                                        </tr>
                                        <tr>
                                            <td class="text-sm-end">NIP</td>
                                            <td>:</td>
                                            <td class="text-sm-start">{{ $perpus_kelasKode->walikelas->guru->nip ?? "Wali Kelas belum di SET"}}</td>
                                        </tr>
                                        <tr>
                                            <td class="text-sm-end">Nama Wali Kelas</td>
                                            <td>:</td>
                                            <td class="text-sm-start">{{ $perpus_kelasKode->walikelas->guru->nama ?? "Wali Kelas belum di SET"}}</td>
                                        </tr>
                                        <tr>
                                            <td class="text-sm-end">Jumlah Siswa</td>
                                            <td>:</td>
                                            <td class="text-sm-start">{{ count($perpus_kelasKode->jmlSiswa) }}</td>
                                        </tr>
                                        @if ($perpus_kelasKode->walikelas == NULL)
                                            {{-- <tr></tr> --}}
                                        @else
                                        <tr>
                                            <td class="text-center" colspan="3">
                                                <a href="{{ url($url)}}/{{ $id }}/edit" class="btn btn-primary" title="Ubah Data" onclick="return confirm('Apakah Anda Yakin ingin ganti Wali kelas {{ $perpus_kelasKode->walikelas->guru->nama }} ?')">Ganti Wali Kelas</a>
                                            </td>
                                        </tr>
                                        @endif
                                    </tbody>
                                </table>
                            </div>
                        </div>
            
                        <div class="card">
                            <div class="card-body">
                                <div class="table-responsive">
                                <table class="table text-center" id="basic-1">
                                    <thead>
                                        <tr>
                                            <th width="50">No.</th>
                                            <th>NISN</th>
                                            <th>Nama</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        {{-- fitur di laravel --}}
                                        @foreach ($perpus_kelasKode->jmlSiswa as $p)
                                            <tr>
                                                <td>{{ $loop->iteration }}</td>
                                                <td>{{ $p->nisn }}</td>
                                                <td>{{ $p->nama }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

    @push('scripts')
    @endpush

@endsection



