@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman</h3>
        @endslot
        <li class="breadcrumb-item">Halaman</li>
        <li class="breadcrumb-item active">List</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                  <div class="card-header">
                    <div class="row">
                        <div class="col-lg-6">
                            <h5 class="card-title">{{ $page }}</h5>
                        </div>
                        <div class="col-lg-6">
                            <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">Kembali</a>
                        </div>
                    </div>
                </div>
                    <form action="{{ url($url) }}/store" method="POST">
                        @csrf            
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Jurusan</label>
                                <select id="select-jurusan" class="form-select select2" name="idPJurusan" aria-label="Default select example" required>
                                    <option value="">Pilih Sekolah Terlebih Dahulu</option>
                                    {{-- @foreach ($jurusan as $r) 
                                        <option value="{{ $r->id }}">{{ $r->nama }}</option>
                                    @endforeach --}}
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Kelas</label>
                                <select id="select-kelas" class="form-select select2" name="idPKelas" aria-label="Default select example" required>
                                    <option value="">Pilih Jurusan Terlebih Dahulu</option>
                                    {{-- @foreach ($kelas as $r) 
                                        <option value="{{ $r->id }}">{{ $r->nama }}</option>
                                    @endforeach --}}
                                </select >
                            </div>
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Kode Kelas</label>
                                <select id="select-kodekelas" class="form-select select2" name="idPKKode" aria-label="Default select example" required>
                                    <option value="">Pilih Kelas Terlebih Dahulu</option>
                                    {{-- @foreach ($kelaskode as $r) 
                                        <option value="{{ $r->id }}">{{ $r->nama }}</option>
                                    @endforeach --}}
                                </select >
                            </div>
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Guru</label>
                                {{-- <div class="col-sm-9"> --}}
                                    <select id="select-sem" class="form-select select2" name="idSGuru" aria-label="Default select example" required>
                                        <option value="">Pilih Guru</option>
                                        @foreach ($guru as $r) 
                                            <option value="{{ $r->id }}">{{ $r->nama }}</option>
                                        @endforeach
                                    </select >
                                {{-- </div> --}}
                            </div>
                        </div>
                        <div class="card-footer">
                            <input type="submit" class="btn btn-primary" value="Simpan">
                            <button class="btn btn-secondary"><a href="{{ url($url) }}" class="text-white">Cancel</a></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    <script>
        $(function() {
            $("#isi-tabel").DataTable(); // tambahin ini ki
    
            let baseUrl     = '{{ url('') }}';
            let idSekolah = "{{ session()->get('idPSekolah') }}";
            let idPeriode = "{{ session()->get('idPPeriode') }}";
            $('#tabel-jquery').hide();
    
            $.getJSON(baseUrl+'/api/sekolahkhusus/getjurusansekolah/'+idSekolah, (result) => {
                if (result.error_code == '0') {
                    let opt = '<option value="">- Pilih Jurusan -</option>';
                    // var dataSem = result.data;
                    // dataSem.sort(function(a, b){
                    //     return a.id_semester - b.id_semester;
                    // });
                    $.each(result.data, function(i, item) {
                        opt += '<option value="'+item.id+'">'+item.nama+'</option>';
                    });
                    $("#select-jurusan").html(opt);
                }else{
                    let opt = '<option value="">- Tidak Bisa -</option>';
                    $("#select-jurusan").html(opt);
                }
                $("#select-jurusan").select2({
                    placeholder: "Pilih Jurusan",
                });
            });
    
            $('#select-jurusan').on('change', function() {
                var val1 = this.value;
                $.getJSON(baseUrl+'/api/sekolah/getkelassekolah/'+val1, (result) => {
                    if (result.error_code == '0') {
                        let opt = '<option value="">- Pilih Kelas -</option>';
                        var dataSem = result.data;
                        dataSem.sort(function(a, b){
                            return a.nama - b.nama;
                        });
                        $.each(result.data, function(i, item) {
                            opt += '<option value="'+item.id+'">'+item.nama+'</option>';
                        });
                        $("#select-kelas").html(opt);
                    }else{
                        let opt = '<option value="">- Tidak Bisa -</option>';
                        $("#select-kelas").html(opt);
                    }
                    $("#select-kelas").select2({
                        placeholder: "Pilih Kelas",
                    });
                });
            });
    
            $('#select-kelas').on('change', function() {
                var val1 = this.value;
                $.getJSON(baseUrl+'/api/sekolah/getkelaskodesekolah/'+val1, (result) => {
                    if (result.error_code == '0') {
                        let opt = '<option value="">- Pilih Kode Kelas -</option>';
                        // var dataSem = result.data;
                        // dataSem.sort(function(a, b){
                        //     return a.id_semester - b.id_semester;
                        // });
                        $.each(result.data, function(i, item) {
                            opt += '<option value="'+item.id+'">'+item.nama+'</option>';
                        });
                        $("#select-kodekelas").html(opt);
                    }else{
                        let opt = '<option value="">- Tidak Bisa -</option>';
                        $("#select-kodekelas").html(opt);
                    }
                    $("#select-kodekelas").select2({
                        placeholder: "Pilih Kode Kelas",
                    });
                });
            });
            $('#select-kodekelas').on('change', function() {
                var val1 = this.value;
                $.getJSON(baseUrl+'/api/sekolah/getgurusekolah/'+val1, (result) => {
                    if (result.error_code == '0') {
                        let opt = '<option value="">- Pilih Kode Kelas -</option>';
                        // var dataSem = result.data;
                        // dataSem.sort(function(a, b){
                        //     return a.id_semester - b.id_semester;
                        // });
                        $.each(result.data, function(i, item) {
                            opt += '<option value="'+item.id+'">'+item.nama+'</option>';
                        });
                        $("#select-guru").html(opt);
                    }else{
                        let opt = '<option value="">- Tidak Bisa -</option>';
                        $("#select-guru").html(opt);
                    }
                    $("#select-guru").select2({
                        placeholder: "Pilih Kode Kelas",
                    });
                });
            });
    
        });
    </script>
    @endpush

@endsection


