@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
<link rel="stylesheet" type="text/css" href="{{ asset('assets/css/select2.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman</h3>
        @endslot
        <li class="breadcrumb-item">Halaman</li>
        <li class="breadcrumb-item active">List</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                  <div class="card-header">
                    <div class="row">
                        <div class="col-lg-6">
                            <h5 class="card-title">{{ $page }}</h5>
                        </div>
                        <div class="col-lg-6">
                            <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">Kembali</a>
                        </div>
                        <div class="col-lg-12">
                            <span class="text-warning">Siswa yang belum atau sudah memiliki konselor akan langsung di replace !</span>
                        </div>
                    </div>
                </div>
                    <form action="{{ url($url) }}/setting-massal-proses" method="POST">
                        @csrf            
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Konselor</label>
                                <select name="idSKonselor" id="select-konselor" class="form-select select2" aria-label="Default select example" required>
                                    <option value="">Pilih Konselor</option>
                                    @foreach ($konselor as $r) 
                                        <option value="{{ $r->id }}">{{ $r->guru->nama }}</option>
                                    @endforeach
                                </select >
                            </div>
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Kelas</label>
                                <div class="mb-2">
                                    <select name="idPKKode[]" id="select-kelas" class="js-example-placeholder-multiple col-sm-12" multiple="multiple" required>
                                        <option value="">Pilih kelas</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <input type="submit" class="btn btn-primary" value="Simpan" onclick="return confirm('Apakah Anda Yakin ingin melakukan Konselor Massal ? Siswa yang belum atau sudah memiliki Konselor akan langsung direplace dengan cara ini !')">
                            <button class="btn btn-secondary"><a href="{{ url($url) }}" class="text-white">Cancel</a></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    <script src="{{ asset('assets/js/select2/select2.full.min.js') }}"></script>
    <script src="{{ asset('assets/js/select2/select2-custom.js') }}"></script>
    <script>

        let baseUrl     = '{{ url('') }}';
        $("#select-konselor").select2({
            placeholder: "Pilih Konselor",
        });

        let idSekolah = "{{ session()->get('idPSekolah') }}";
        $.getJSON(baseUrl+'/getKelasKomplit/'+idSekolah, (result) => {
            if (result.error_code == '0') {
                let opt = '<option value="">- Pilih Kelas -</option>';
                var dataSem = result.data;
                dataSem.sort(function(a, b){
                    return a.nama - b.nama;
                });
                $.each(result.data, function(i, item) {
                    opt += '<option value="'+item.id+'">'+item.nama+'</option>';
                });
                $("#select-kelas").html(opt);
            }else{
                let opt = '<option value="">- Tidak Bisa -</option>';
                $("#select-kelas").html(opt);
            }
            $("#select-kelas").select2({
                placeholder: "Pilih Kelas",
            });
        });
    </script>
    @endpush

@endsection


