@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman</h3>
        @endslot
        <li class="breadcrumb-item">Halaman</li>
        <li class="breadcrumb-item active">List</li>
    @endcomponent

    
    <div class="container-fluid pt-4">
                    
        <div class="row justify-content-center">
            <div class="col-lg-10 col-sm-12">
                <div class="card border-top border-0 border-4 border-info">
                    <div class="card-header p-3">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">{{ $page }}</h5>
                            </div>
                            <div class="col-lg-6">
                                <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">kembali</a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <table id="datatable" class="table text-center">
                            <tbody>
                                <tr>
                                    <td class="text-sm-end"><b>Nama Sekolah</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $guru->sekolah->nama }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end">NIP</td>
                                    <td>:</td>
                                    <td class="text-sm-start">{{ $guru->nip }}</td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end">Nama</td>
                                    <td>:</td>
                                    <td class="text-sm-start">{{ $guru->nama }}</td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end">Mata Pelajaran</td>
                                    <td>:</td>
                                    <td class="text-sm-start">{{ $guru->mapel->nama }}</td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end">Status</td>
                                    <td>:</td>
                                    @if ($guru->status == 1)
                                        <td class="text-sm-start">Aktif</td>
                                    @else
                                        <td class="text-sm-start">Tidak Aktif</td>
                                    @endif
                                </tr>
                                <tr>
                                    <td></td>
                                    <td>
                                        <a href="{{ url($url)}}/{{ $guru->id }}/edit" class="btn btn-primary">Edit</a>
                                        <div class="mt-2">

                                            @if ($guru->status == 1)
                                                <a href="{{ url($url)}}/update-status/{{ $guru->id }}" class="btn btn-warning" onclick="return confirm('Apakah anda yakin ingin meng-Non Aktifkan Guru ini ? Beberapa data terkait Guru ini selanjutnya perlu disesuaikan');">Non Aktifkan</a>
                                            @elseif($guru->status == 0)
                                                <a href="{{ url($url)}}/update-status/{{ $guru->id }}" class="btn btn-warning" onclick="return confirm('Apakah anda yakin ingin meng Aktifkan Guru ini ? Beberapa data terkait Guru ini selanjutnya perlu disesuaikan');">Aktifkan</a>
                                            @endif
                                            <a href="{{ url($url)}}/delete/{{ $guru->id }}" class="btn btn-danger" onclick="return confirm('Apakah anda yakin ingin meng-Hapus Guru ini ? Beberapa data terkait Guru ini selanjutnya perlu disesuaikan');">Hapus</a>
                                        </div>
                                    </td>
                                    <td></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
    
            </div>
        </div>
    </div>

    @push('scripts')
    @endpush

@endsection
