@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman</h3>
        @endslot
        <li class="breadcrumb-item">Halaman</li>
        <li class="breadcrumb-item active">List</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                  <div class="card-header">
                    <div class="row">
                        <div class="col-lg-6">
                            <h5 class="card-title">{{ $page }}</h5>
                        </div>
                        <div class="col-lg-6">
                            <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">Kembali</a>
                        </div>
                    </div>
                </div>
                    <form action="{{ url($url)}}/update/{{ $guru->id }}" method="post">
                        @csrf
                        @method('PUT')
                        <div class="card-body">
                            <div class="form-group">
                                <label>NIP</label>
                                <input type="text" id="i-nama" class="form-control" name="nip" placeholder="nip" value="{{ $guru->nip }}">
                            </div>
                            <div class="form-group">
                                <label>Nama Guru</label>
                                <input type="text" id="i-nama" class="form-control" name="nama" placeholder="Nama Ortu" value="{{ $guru->nama }}">
                            </div>
                            <div class="form-group">
                                <label>Mapel</label>
                                <select class="form-select select2" name="idMapel" aria-label="Default select example">
                                    @foreach ($mapel as $r)
                                        <option value="{{ $r->id }}" {{ $guru->idMapel == $r->id ? 'selected' : '' }}>{{ $r->nama }}</option>
                                    @endforeach
                                </select >
                            </div>
                            <div class="form-group mt-3">
                                <button type="submit" class="btn btn-primary">Simpan</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    @endpush

@endsection
