@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/select2.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Siswa</h3>
        @endslot
        <li class="breadcrumb-item">Siswa</li>
        <li class="breadcrumb-item active">Edit</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-6">
                            <h5 class="card-title">{{ $page }}</h5>
                        </div>
                        <div class="col-lg-6">
                            <a href="{{ redirect()->back()->getTargetUrl() }}" class="btn btn-sm btn-primary float-end">Kembali</a>
                        </div>
                    </div>
                </div>
                    <form action="{{ url($url) }}/update/{{ $siswa->id }}" method="post">
                        @csrf
                        @method('PUT')
                        <div class="card-body">
                            <div class="form-group">
                                <div class="form-group">
                                    <label class="col-sm-3 col-form-label">Kode Kelas</label>
                                    <select id="select-kelas" class="form-select select2 @error('idPKKode') is-invalid @enderror" name="idPKKode" aria-label="Default select example">
                                        @foreach ($kelaskode as $r) 
                                            <option value="{{ $r->id }}" {{ old('idPKKode', $siswa->idPKKode) == $r->id ? 'selected' : '' }}>
                                                {{ $r->kelas->nama }} {{ $r->jurusan->nama }} {{ $r->nama }}
                                            </option>
                                        @endforeach
                                    </select >
                                </div>
                                <div class="form-group">
                                    <label class="col-sm-3 col-form-label">Pilih Guru Konseling</label>
                                    <select id="select-sem" class="form-select select2 @error('idSKonselor') is-invalid @enderror" name="idSKonselor" aria-label="Default select example" required>
                                        <option value="">Pilih Guru Konseling</option>
                                        @foreach ($konselor as $r) 
                                            <option value="{{ $r->id }}" {{ old('idSKonselor', $siswa->konselor?->id) == $r->id ? 'selected' : '' }}>
                                                {{ $r->guru->nama }}
                                            </option>
                                        @endforeach
                                    </select >
                                </div>
                                <div class="form-group">
                                    <label class="col-sm-3 col-form-label">Agama</label>
                                    <select id="select-sem" class="form-select select2 @error('idMAgama') is-invalid @enderror" name="idMAgama" aria-label="Default select example">
                                        <option value="">Pilih Agama</option>
                                        @foreach ($agama as $r) 
                                            <option value="{{ $r->id }}" {{ old('idMAgama', $siswa->agama?->id) == $r->id ? 'selected' : '' }}>
                                                {{ $r->nama }}
                                            </option>
                                        @endforeach
                                    </select >
                                </div>
                                <div class="form-group">
                                    <label>NISN</label>
                                    <input type="text" id="i-nama" class="form-control @error('nisn') is-invalid @enderror" name="nisn" placeholder="nisn" value="{{ old('nisn',$siswa->nisn) }}" required>
                                </div>
                                <div class="form-group">
                                    <label>Nama</label>
                                    <input type="text" id="i-nama" class="form-control @error('nama') is-invalid @enderror" name="nama" placeholder="Nama" value="{{ old('nama',$siswa->nama) }}" required>
                                </div>
                                <div class="form-group">
                                    <label class="col-form-label pt-0" for="exampleInputEmail1">Tanggal Lahir</label>
                                    <div class="input-group date" id="dt-date" data-target-input="nearest">
                                        <input class="form-control datetimepicker-input digits @error('lahir_tanggal') is-invalid @enderror" name="lahir_tanggal" type="text" data-target="#dt-date" value="{{ old('lahir_tanggal',$siswa->lahir_tanggal) }}">
                                        <div class="input-group-text" data-target="#dt-date" data-toggle="datetimepicker"><i class="fa fa-calendar"></i></div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label>Tempat Lahir</label>
                                    <input type="text" id="i-nama" class="form-control @error('lahir_tempat') is-invalid @enderror" name="lahir_tempat" placeholder="Tempat Lahir" value="{{ old('lahir_tempat', $siswa->lahir_tempat) }}">
                                </div>
                                <div class="form-group">
                                    <label class="col-form-label pt-0" for="exampleInputEmail1">Email</label>
                                    <input name="email" class="form-control @error('email') is-invalid @enderror" type="email" placeholder="masukkan email" value="{{ $siswa->email }}" value="{{ old('email', $siswa->email) }}">
                                </div>
                                <div class="form-group">
                                    <label class="col-form-label pt-0" for="exampleInputEmail1">No Telp</label>
                                    <input name="telp" class="form-control @error('telp') is-invalid @enderror" type="text" placeholder="masukkan nomor" value="{{ $siswa->telp }}" value="{{ old('telp', $siswa->telp) }}" required>
                                </div>
                                <div class="form-group">
                                    <label class="col-sm-3 col-form-label">Tempat Tinggal</label>
                                    <select id="select-sem" class="form-select select2 @error('idMTempat') is-invalid @enderror" name="idMTempat" aria-label="Default select example" required>
                                        <option value="">Pilih Tempat Tinggal</option>
                                        @foreach ($tempat as $r) 
                                            <option value="{{ $r->id }}" {{ old('idMTempat', $siswa->idMTempat) == $r->id ? 'selected' : '' }}>
                                                {{ $r->nama }}
                                            </option>
                                        @endforeach
                                    </select >
                                </div>
                            </div>


                            <div class="form-group mt-3">
                                <button type="submit" class="btn btn-primary">Simpan</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
        <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
        <script src="{{ asset('assets/js/select2/select2.full.min.js') }}"></script>
        <script src="{{ asset('assets/js/select2/select2-custom.js') }}"></script>
        <script>

                $("#select-kelas").select2({
                    placeholder: "Pilih Kelas",
                });
        </script>
    @endpush

@endsection
