@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Saran</h3>
        @endslot
        <li class="breadcrumb-item">Saran</li>
        <li class="breadcrumb-item active">Kirim</li>
    @endcomponent

    <div class="container-fluid pt-4">
                        
        <div class="row justify-content-center">
            <div class="col-lg-10 col-sm-12">
                <div class="card border-top border-0 border-4 border-info">
                    <div class="card-header p-3">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">{{ $page }}</h5>
                            </div>
                            <div class="col-lg-6">
                                
                                @if (session()->get('role') == 1)
                                    @if ($saran['status'] == 1)
                                        <a href="{{ url('admin/saran') }}/{{ $saran->id }}/edit" class="btn btn-sm btn-primary float-end">Buat Tanggapan</a>
                                    @endif
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <table id="datatable" class="table text-center">
                            <tbody>
                                <tr>
                                    <td class="text-sm-end"><b>Nama</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $saran->nama }}</b></td>
                                </tr>
                                
                                <tr>
                                    <td class="text-sm-end">No Telp</td>
                                    <td>:</td>
                                    <td class="text-sm-start">{{ $saran->telp }} </td>
                                </tr>

                                <tr>
                                    <td class="text-sm-end">Saran</td>
                                    <td>:</td>
                                    <td class="text-sm-start">{{ $saran->saran }} </td>
                                </tr>

                                <tr>
                                    <td class="text-sm-end">Tanggapan</td>
                                    <td>:</td>
                                    <td class="text-sm-start">{{ $saran->tanggapan ?? 'Belum Ada Tanggapan' }} </td>
                                </tr>
                            </tbody>
                        </table>  
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
        <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
    @endpush

    @endsection

