@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Uuslan Admin Sekolah</h3>
        @endslot
        <li class="breadcrumb-item">Admin Sekolah</li>
        <li class="breadcrumb-item">Usulan</li>
        <li class="breadcrumb-item active">Detail</li>
    @endcomponent

    <div class="container-fluid pt-4">
                        
        <div class="row justify-content-center">
            <div class="col-lg-10 col-sm-12">
                <div class="card border-top border-0 border-4 border-info">
                    <div class="card-header p-3">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">{{ $page }}</h5>
                            </div>
                            <div class="col-lg-6">
                                <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">kembali</a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <table id="datatable" class="table text-center">
                            <tbody>
                                    <tr>
                                        <td class="text-sm-end"><b>Daerah</b></td>
                                        <td>:</td>
                                        <td class="text-sm-start"><b>{{ $usulan->daerah->provinsi->nama }} - {{ $usulan->daerah->nama }}</b></td>
                                    </tr>
                                    <tr>
                                        <td class="text-sm-end"><b>Periode</b></td>
                                        <td>:</td>
                                        <td class="text-sm-start"><b>{{ $usulan->periode->nama }}</b></td>
                                    </tr>
                                    <tr>
                                        <td class="text-sm-end"><b>NPSN Sekolah</b></td>
                                        <td>:</td>
                                        <td class="text-sm-start"><b>{{ $usulan->npsn }}</b></td>
                                    </tr>
                                    <tr>
                                        <td class="text-sm-end"><b>Nama Sekolah</b></td>
                                        <td>:</td>
                                        <td class="text-sm-start"><b>{{ $usulan->nama }}</b></td>
                                    </tr>
                                    <tr>
                                        <td class="text-sm-end"><b>Nama Admin</b></td>
                                        <td>:</td>
                                        <td class="text-sm-start"><b>{{ $usulan->admin }}</b></td>
                                    </tr>
                                    <tr>
                                        <td class="text-sm-end"><b>Nomor Telp Admin</b></td>
                                        <td>:</td>
                                        <td class="text-sm-start"><b>{{ $usulan->nomor }}</b></td>
                                    </tr>
                                    <tr>
                                        <td class="text-sm-end"><b>Surat Pengantar Kepsek</b></td>
                                        <td>:</td>
                                        <td class="text-sm-start">
                                            <a href="{{ asset('upload/surat_usulan') }}/{{ $usulan->surat ?? '' }}" alt="Tidak tersedia">Download</a>
                                        </td>
                                    </tr>
                                    <tr>
                                        @if ($usulan->status == 0)
                                            <td colspan="3">
                                                <a href="{{ url($url)}}/{{ $usulan->id }}/accept" class="btn btn-primary" title="Ubah Data" onclick="return confirm('Apakah Anda Yakin menerima usulan ini ?')">Terima</a>
                                                <a href="{{ url($url)}}/{{ $usulan->id }}/decline" class="btn btn-warning" title="Ubah Data" onclick="return confirm('Apakah Anda Yakin menolak usulan ini ?')">Tolak</a>
                                            </td>                                                
                                        @else
                                            <td class="text-sm-end"><b>Status</b></td>
                                            <td>:</td>
                                            <td class="text-sm-start">
                                                <b>
                                                @if ($usulan->status == 0)
                                                    <span class="text-warning">Menunggu</span>
                                                @elseif ($usulan->status == 1)
                                                    <span class="text-info">Approved</span>
                                                @elseif ($usulan->status == 2)
                                                    <span class="text-danger">ditolak</span>
                                                @endif
                                                </b>
                                            </td>
                                        @endif
                                    </tr>
                            </tbody>
                        </table>  
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
@endpush

@endsection
