@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/select2.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Uuslan Admin Sekolah</h3>
        @endslot
        <li class="breadcrumb-item">Admin Sekolah</li>
        <li class="breadcrumb-item">Usulan</li>
        <li class="breadcrumb-item active">List</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                {{-- Diberikan alert --}}
                @if (session()->has('sukses'))
                    <div class="alert alert-success" role="alert">
                        {{ session('sukses') }}
                    </div>
                @elseif (session()->has('gagal'))
                    <div class="alert alert-danger" role="alert">
                        {{ session('gagal') }}
                    </div>
                @endif
                <div class="card">
                    <div class="card-header p-3">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">{{ $page }}</h5>
                            </div>
                            <div class="col-lg-6">
                                <a href="{{ url($url) }}/create" class="btn btn-sm btn-primary float-end">Tambah Indeks Kelas</a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive" id="tabel-jquery">
                            <table id="isi-tabel" class="table table-striped table-bordered dt-responsive nowrap dataTable no-footer dtr-inline collapsed">
                                <thead>
                                    <tr>
                                        <th width="50">No.</th>
                                        <th>NPSN</th>
                                        <th>Nama Sekolah</th>
                                        <th>Status</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($usulan as $r)
                                        <tr>
                                            <td>{{ $loop->iteration }}</td>
                                            <td>{{ $r->npsn }}</td>
                                            <td>{{ $r->nama }}</td>
                                            <td>
                                                @if ($r->status == 0)
                                                    <span class="text-warning">Menunggu</span>
                                                @elseif ($r->status == 1)
                                                    <span class="text-info">Approved</span>
                                                @elseif ($r->status == 2)
                                                    <span class="text-danger">ditolak</span>
                                                @endif
                                            </td>
                                            <td>
                                                <a href="{{ url($url)}}/{{ $r->id }}" class="btn btn-primary" title="Detail Data">Detail</a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

    @push('scripts')
        <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
        <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
        <script>
            $("#isi-tabel").DataTable();
        </script>
    @endpush

@endsection
