@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/select2.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Master Indeks Kelas</h3>
        @endslot
        <li class="breadcrumb-item">Master</li>
        <li class="breadcrumb-item">Indeks Kelas</li>
        <li class="breadcrumb-item active">Detail</li>
    @endcomponent

    <div class="container-fluid pt-4">
                        
        <div class="row justify-content-center">
            <div class="col-lg-10 col-sm-12">
                <div class="card border-top border-0 border-4 border-info">
                    <div class="card-header p-3">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">{{ $page }}</h5>
                            </div>
                            <div class="col-lg-6 col-sm-12">
                                <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">kembali</a>
                                {{-- <a href="{{ url('sekolah/import_siswaKelas/' . $perpus_kelasKode->id, []) }}/edit" class="btn btn-sm btn-secondary float-end">Import Data Siswa</a> --}}
                                <button class="btn btn-sm btn-secondary float-end" data-bs-toggle="modal" data-bs-target="#modalImport" data-id="{{ $perpus_kelasKode->id }}" id="kodeKelasId">Import Data Siswa</button>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <table id="datatable" class="table text-center">
                            <tbody>
                                <tr>
                                    <td class="text-sm-end"><b>Nama Sekolah</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $perpus_kelasKode->sekolah->nama }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end">Kelas</td>
                                    <td>:</td>
                                    <td class="text-sm-start">{{ $perpus_kelasKode->kelas->nama.' '.$perpus_kelasKode->kelas->jurusan->nama.' '.$perpus_kelasKode->nama }}</td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end">Nama Wali Kelas</td>
                                    <td>:</td>
                                    <td class="text-sm-start">{{ $perpus_kelasKode->walikelas->guru->nama ?? "Wali kelas belum di SET" }}</td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end">Nip Wali Kelas</td>
                                    <td>:</td>
                                    <td class="text-sm-start">{{ $perpus_kelasKode->walikelas->guru->nip ?? "Wali kelas belum di SET" }}</td>
                                </tr>
                                <tr>
                                    <td colspan="3">
                                        <form action="{{ url($url) }}/delete/{{ $perpus_kelasKode->id }}" method="POST"> @csrf @method('delete')
                                            <input type="submit" value="Hapus index kelas" class="btn btn-sm btn-primary" onclick="return confirm('Apakah Anda Yakin Hapus {{ $perpus_kelasKode->kelas->nama.' '.$perpus_kelasKode->kelas->jurusan->nama.' '.$perpus_kelasKode->nama }} ? siswa akan tetap dikelas ini sebagai siswa historis')">
                                        </form>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div class="row justify-content-center">
        <div class="col-lg-10 col-sm-12">
            <div class="card border-top border-0 border-4 border-info">
                <div class="table-responsive" id="tabel-jquery">
                    <table id="isi-tabel" class="table table-striped table-bordered dt-responsive nowrap dataTable no-footer dtr-inline collapsed">
                        <thead >
                            <tr>
                                <th data-priority="1" width="50px">No.</th>
                                <th>NISN</th>
                                <th>Nama</th>
                                <th width="250">Action</th>
                            </tr>
                        </thead>
                        <tbody>

                            
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    

    <div class="modal fade" id="modalImport" tabindex="-1" style="display: none;" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Import</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group mb-3">
                        <a href="{{ url('excel-template/format_input_siswa_kelas.xlsx') }}" class="btn btn-sm btn-primary">Download Template</a>
                    </div>
                    <div class="form-group mb-3">
    
                        <form action="{{ url($url) }}/import" method="post" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" id="iKelasKodeId" name="kelasKode">
                        <div class="row">
                            <div class="col-md-12">
                                <label class="col-sm-3 col-form-label" for="exampleFormControlTextarea4">Import Excel</label>
                                <input class="form-control @error('file_excel') is-invalid @enderror" name="file_excel" type="file" accept=".csv, .xls, .xlsx"> 
                                @error('file_excel')
                                    <div class="invalid-feedback">
                                    {{ $message }}
                                    </div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Simpan</button>
                </div>
            </form>
            </div>
        </div>
    </div>

    @push('scripts')
    <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
    <script src="{{ asset('assets/js/clipboard/clipboard.min.js') }}"></script>
    <script src="{{ asset('assets/js/clipboard/clipboard-script.js') }}"></script>
     
    <script>
        $("#isi-tabel").DataTable(); // tambahin ini ki

        let baseUrl     = '{{ url('') }}';
        $('#tabel-jquery').hide();
    </script>
    <script>
        // Show Edit
        $("#kodeKelasId").on("click", function() {
            let dataId = $(this).data("id")
            $("#iKelasKodeId").val(dataId)
        });

        $('#select-agama').on('change', function() {
            $("#enAgama").val(this.value);
        });

        $('#select-konselor').on('change', function() {
            $("#enKonselor").val(this.value);
        });

        $('#select-tempat').on('change', function() {
            $("#enTempat").val(this.value);
        });

        $('#select-pekerjaan').on('change', function() {
            $("#enPekerjaan").val(this.value);
        });

        $("#isi-tabel").DataTable().clear().destroy(); // tambahin ini ki
        
        $('#tabel-jquery').show();
        var idPKelas = {{ $perpus_kelasKode->id }};
        // console.log(idPKKode);
        // var val3 = this.value;
        
        $("#isi-tabel").DataTable({
        // $("#tabel-jquery")({
            language: { // tambahin ini ki
                emptyTable: "Tidak ada data Kelas",
                info: "Total: _TOTAL_ Data Kelas",
                infoEmpty: "Menampilkan 0 dari 0 Data Kelas",
            },
            responsive:  true,
            autoWidth: false,
            processing: true,
            ajax: {
                url: baseUrl+'/siswa/getTabelSekolahSiswa/' + idPKelas,
                method: 'GET',
            },
            dom: 'Bfrtip',
            buttons: [
                'copy', 'excel', 'pdf', 'colvis'
            ]
        });
    </script>
    @endpush

@endsection
