@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Master Tingkat</h3>
        @endslot
        <li class="breadcrumb-item">Master</li>
        <li class="breadcrumb-item">Tingkat</li>
        <li class="breadcrumb-item active">Detail</li>
    @endcomponent

    
    <div class="container-fluid pt-4">
                        
        <div class="row justify-content-center">
            <div class="col-lg-10 col-sm-12">
                <div class="card border-top border-0 border-4 border-info">
                    <div class="card-header p-3">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">{{ $page }}</h5>
                            </div>
                            <div class="col-lg-6">
                                <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">kembali</a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <table id="datatable" class="table text-center">
                            <tbody>
                                <tr>
                                    <td class="text-sm-end"><b>Nama Sekolah</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $perpus_kelas->sekolah->nama }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Nama Jurusan</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $perpus_kelas->jurusan->nama }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Tingkat</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $perpus_kelas->nama }}</b></td>
                                </tr>
                                @foreach ($perpus_kelas->kelaskode as $p)
                                    <tr>
                                        <td class="text-sm-end">Kelas</td>
                                        <td>:</td>
                                        <td class="text-sm-start">{{ $p->nama }} <a href="{{ url($url2. "/" . $p->id, []) }}" ><i class="fa fa-info-circle"></i></a></td>
                                    </tr>
                                @endforeach
                                <tr>
                                    <td colspan="3">
                                        <form action="{{ url($url) }}/delete/{{ $perpus_kelas->id }}" method="POST"> @csrf @method('delete')
                                            <input type="submit" value="Hapus tingkat" class="btn btn-sm btn-primary" onclick="return confirm('Apakah Anda Yakin Hapus tingkat {{ $perpus_kelas->nama.' di '.$perpus_kelas->jurusan->nama }} ? siswa akan tetap di tingkat ini sebagai siswa historis. Seluruh indeks kelas dalam tingkat ini akan dihapus')">
                                        </form>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    @endpush

@endsection
