@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Master Jurusan</h3>
        @endslot
        <li class="breadcrumb-item">Master</li>
        <li class="breadcrumb-item">Jurusan</li>
        <li class="breadcrumb-item active">Detail</li>
    @endcomponent

    <div class="container-fluid pt-4">
                        
        <div class="row justify-content-center">
            <div class="col-lg-10 col-sm-12">
                <div class="card border-top border-0 border-4 border-info">
                    <div class="card-header p-3">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">{{ $page }}</h5>
                            </div>
                            <div class="col-lg-6">
                                <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">kembali</a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <table id="datatable" class="table text-center">
                            <tbody>
                                <tr>
                                    <td class="text-sm-end"><b>Nama Sekolah</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $perpus_jurusan->sekolah->nama }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Nama Jurusan</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $perpus_jurusan->nama }}</b></td>
                                </tr>
                                @foreach ($perpus_jurusan->kelas as $p)
                                    
                                    <tr>
                                        <td class="text-sm-end">Kelas</td>
                                        <td>:</td>
                                        <td class="text-sm-start">{{ $p->nama }} <a href="{{ url($url2. "/" . $p->id, []) }}" ><i class="fa fa-info-circle"></i></a></td>
                                    </tr>
                                @endforeach
                                <tr>
                                    <td colspan="3">
                                        <form action="{{ url($url) }}/delete/{{ $perpus_jurusan->id }}" method="POST"> @csrf @method('delete')
                                            <input type="submit" value="Hapus jurusan" class="btn btn-sm btn-primary" onclick="return confirm('Apakah Anda Yakin Hapus jurusan {{ $perpus_jurusan->nama }} ? siswa akan tetap di jurusan ini sebagai siswa historis. Seluruh indeks kelas dan tingkat dalam jurusan ini akan dihapus')">
                                        </form>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    @endpush

@endsection
