@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/select2.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Master Jurusan</h3>
        @endslot
        <li class="breadcrumb-item">Master</li>
        <li class="breadcrumb-item">Jurusan</li>
        <li class="breadcrumb-item active">List</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                {{-- Diberikan alert --}}
                @if (session()->has('sukses'))
                    <div class="alert alert-success" role="alert">
                        {{ session('sukses') }}
                    </div>
                @elseif (session()->has('gagal'))
                    <div class="alert alert-danger" role="alert">
                        {{ session('gagal') }}
                    </div>
                @endif
                <div class="card">
                    <div class="card-header p-3">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">{{ $page }}</h5>
                            </div>
                            <div class="col-lg-6">
                                <a href="{{ url($url) }}/create" class="btn btn-sm btn-primary float-end">Tambah Jurusan</a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">

                        @if (session()->get('role') == 1)
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Provinsi</label>
                                <select id="select-provinsi" class="form-select select2" name="idMProvinsi" aria-label="Default select example" required>
                                    <option value="">Pilihan Provinsi Sedang di Proses</option>
                                    {{-- @foreach ($provinsi as $r) 
                                        <option value="{{ $r->id }}">{{ $r->nama }}</option>
                                    @endforeach --}}
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Daerah</label>
                                <select id="select-daerah" class="form-select select2" name="idMDaerah" aria-label="Default select example" required>
                                    <option value="">Pilih Provinsi Terlebih Dahulu</option>
                                    {{-- @foreach ($sekolah as $r) 
                                        <option value="{{ $r->id }}">{{ $r->nama }}</option>
                                    @endforeach --}}
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Sekolah</label>
                                <select id="select-sekolah" class="form-select select2" name="idPSekolah" aria-label="Default select example" required>
                                    <option value="">Pilih Daerah Terlebih Dahulu</option>
                                    {{-- @foreach ($sekolah as $r) 
                                        <option value="{{ $r->id }}">{{ $r->nama }}</option>
                                    @endforeach --}}
                                </select >
                            </div>
                        @endif
                        <div class="table-responsive" id="tabel-jquery">
                            <table id="isi-tabel" class="table table-striped table-bordered dt-responsive nowrap dataTable no-footer dtr-inline collapsed">
                            <thead>
                                <tr>
                                    <th width="50">No.</th>
                                    @if (session()->get('role') == 1)
                                        <th>Nama Sekolah</th>    
                                    @endif
                                    <th>Jurusan</th>
                                    <th width="150">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                {{-- fitur di laravel --}}
                            </tbody>
                        </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
    <script src="{{ asset('assets/js/select2/select2.full.min.js') }}"></script>
    <script src="{{ asset('assets/js/select2/select2-custom.js') }}"></script>
    <script>
        $("#isi-tabel").DataTable();

        let baseUrl     = '{{ url('') }}';
        $('#tabel-jquery').hide();
    </script>
    @include('admin.filter.perpus')
    <script>
        @if (session()->get('role') == 1)

            $('#select-sekolah').on('change', function() {
                $("#isi-tabel").DataTable().clear().destroy(); // tambahin ini ki
                
                $('#tabel-jquery').show();
                var idPSekolah = $('#select-sekolah').val();
                // console.log(idPKKode);
                // var val3 = this.value;
                $("#isi-tabel").DataTable({
                    language: { 
                        emptyTable: "Tidak ada data Sekolah",
                        info: "Total: _TOTAL_ Data Sekolah",
                        infoEmpty: "Menampilkan 0 dari 0 Data Sekolah",
                    },
                    responsive:  true,
                    autoWidth: false,
                    processing: true,
                    ajax: {
                        url: baseUrl+'/perpus/getTabelSekolahJurusan/' +idPSekolah,
                        method: 'GET',
                    },
                    dom: 'Bfrtip',
                    buttons: [
                        'copy', 'excel', 'pdf', 'colvis'
                    ]
                });
            });
        @elseif (session()->get('role') == 2)
            $("#isi-tabel").DataTable().clear().destroy(); 
            $('#tabel-jquery').show();
            
            $("#isi-tabel").DataTable({
                language: { 
                    emptyTable: "Tidak ada data Sekolah",
                    info: "Total: _TOTAL_ Data Sekolah",
                    infoEmpty: "Menampilkan 0 dari 0 Data Sekolah",
                },
                responsive:  true,
                autoWidth: false,
                processing: true,
                ajax: {
                    url: baseUrl+'/perpus/getTabelSekolahJurusan/' +"{{ session()->get('idPSekolah') }}",
                    method: 'GET',
                },
                dom: 'Bfrtip',
                buttons: [
                    'copy', 'excel', 'pdf', 'colvis'
                ]
            });
        @endif
    </script>
    @endpush

@endsection
