@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/select2.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman</h3>
        @endslot
        <li class="breadcrumb-item">Halaman</li>
        <li class="breadcrumb-item active">List</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                  <div class="card-header">
                    <div class="row">
                        <div class="col-lg-6">
                            <h5 class="card-title">{{ $page }} - {{ $kelasSkr->kelas->nama.' '.$kelasSkr->kelas->jurusan->nama.' '.$kelasSkr->nama }}</h5>
                        </div>
                        <div class="col-lg-6">
                            <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">Kembali</a>
                        </div>
                    </div>
                </div>
                    <form action="{{ url($url)}}/update/{{ $kelasSkr->id }}" method="post">
                        @csrf
                        @method('PUT')
                        <div class="card-body">
                            <div class="form-group">
                                <div class="form-group row ">
                                    <div class="col-lg-3">
                                        <h5 class="card-title">NISN</h5>
                                    </div>
                                    <div class="col-lg-3">
                                        <h5 class="card-title">Nama</h5>
                                    </div>
                                    <div class="col-lg-3">
                                        <h5 class="card-title">Pindah Kelas</h5>
                                    </div>
                                    <div class="col-lg-3">
                                        <h5 class="card-title">Ganti Status</h5>
                                    </div>
                                    {{-- <div class="col-lg-3">
                                        <h5 class="card-title">Check Ganti</h5>
                                    </div> --}}
                                </div>
                                @foreach ($siswa as $r)
                                    <div class="form-group row ">
                                        <div class="col-lg-3">
                                            <input type="text" class="form-control" disabled value="{{ $r->nisn }}">
                                        </div>
                                        <div class="col-lg-3">
                                            <input type="text" class="form-control" disabled value="{{ $r->nama }}">
                                        </div>
                                        <input type="hidden" name="idSiswa[]" value="{{ $r->id }}">
                                        <div class="col-lg-3">
                                            <select class="js-example-basic-single" name="idKelas[]">
                                                @foreach ($kelas as $k)
                                                    <option value="{{ $k->id }}">{{ $k->kelas->nama.' '.$k->kelas->jurusan->nama.' '.$k->nama }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-lg-3">
                                            <select class="js-example-basic-single" name="idStatus[]">
                                                @foreach ($siswaStatus as $ss)
                                                    <option value="{{ $ss->id }}">{{ $ss->nama }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        {{-- <div class="col-lg-3">
                                            <input id="inline-1" name="cek[]" type="checkbox" value="{{ enc($r->nisn) }}" style="height: 25px; width: 25px;">
                                        </div> --}}
                                    </div>
                                @endforeach  
                            </div>
            
            
                            <div class="form-group mt-3">
                                <button type="submit" onclick="return confirm('Apakah Anda Yakin? Data tidak akan bisa diubah lagi')" class="btn btn-primary">Simpan</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
        <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
        <script src="{{ asset('assets/js/select2/select2.full.min.js') }}"></script>
        <script src="{{ asset('assets/js/select2/select2-custom.js') }}"></script>
    @endpush

@endsection

    
    