@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman Detail</h3>
        @endslot
        <li class="breadcrumb-item">Detail</li>
        <li class="breadcrumb-item active">Data</li>
    @endcomponent

    <div class="container-fluid pt-4">
                        
        <div class="row justify-content-center">
            <div class="col-lg-10 col-sm-12">
                <div class="card border-top border-0 border-4 border-info">
                    <div class="card-header p-3">
                        <div class="row">
                            <div class="col-lg-6">
                                <h6 class="card-title">{{ $page }}</h6>
                            </div>
                            <div class="col-lg-6">
                                <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">kembali</a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <table id="datatable" class="table text-center">
                            <tbody>
                                <tr>
                                    <td class="text-sm-end"><b>Nama Siswa</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $undangOrtu->siswa->nama }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Kelas Siswa</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $undangOrtu->kelaskode->kelas->nama.' '.$undangOrtu->kelaskode->kelas->jurusan->nama.' '.$undangOrtu->kelaskode->nama }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Tanggal Surat</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $undangOrtu->surat_waktu }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Nomor Surat</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $undangOrtu->nomor }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Panggilan Ke</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $undangOrtu->panggilan_berapa }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Tempat</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $undangOrtu->surat_tempat }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Nama Kepsek</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $undangOrtu->kepsek->guru->nama ?? 'Kepsek belum di SET' }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Nip Kepsek</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $undangOrtu->kepsek->guru->nip ?? 'Kepsek belum di SET' }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Nama Ortu</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $undangOrtu->ortu->nama }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Hari Panggil</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $undangOrtu->isian_hari }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Tanggal Panggil</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $undangOrtu->isian_tanggal }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Jam</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $undangOrtu->isian_pukul }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Keperluan</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $undangOrtu->isian_keperluan }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Bertemu dengan</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $undangOrtu->isian_bertemu }}</b></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="card-footer">
                        <div >
                            <form action="{{ url($url) }}/delete/{{ $undangOrtu->kode_unik }}" method="POST"> @csrf @method('delete')
                                <input type="submit" value="delete" class="btn btn-sm btn-primary float-end" onclick="return confirm('Apakah anda yakin mau hapus ?')">
                            </form>
                            <a href="{{ url("$url/" . $undangOrtu->kode_unik, []) }}/download" class="btn btn-sm btn-primary float-end">unduh</a>
                            <a href="{{ url("$url/" . $undangOrtu->kode_unik, []) }}/edit" class="btn btn-sm btn-primary float-end">edit</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    @endpush

@endsection