@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman Detail</h3>
        @endslot
        <li class="breadcrumb-item">Detail</li>
        <li class="breadcrumb-item active">Data</li>
    @endcomponent
<div class="container-fluid pt-4">
                    
    <div class="row justify-content-center">
        <div class="col-lg-10 col-sm-12">
            <div class="card border-top border-0 border-4 border-info">
                <div class="card-header p-3">
                    <div class="row">
                        <div class="col-lg-6">
                            <h5 class="card-title">{{ $page }}</h5>
                        </div>
                        <div class="col-lg-6">
                            <a href="{{ url('konselor/surat/sp_mundur') }}" class="btn btn-sm btn-primary float-end">kembali</a>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <table id="datatable" class="table text-center">
                        <tbody>
                            <tr>
                                <td class="text-sm-end"><b>Nama Siswa</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $mundur->siswa->nama }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Kelas Siswa</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $mundur->kelaskode->kelas->nama.' '.$mundur->kelaskode->kelas->jurusan->nama.' '.$mundur->kelaskode->nama }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>No Induk Siswa</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $mundur->siswa->nisn }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Nama Ortu</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $mundur->ortu->nama }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Pekerjaan Ortu</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $mundur->ortu->pekerjaan->nama }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Alamat Ortu</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $mundur->ortu->alamat }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Tempat</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $mundur->surat_tempat }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Tanggal Surat</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $mundur->surat_waktu }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Nama Wali Kelas</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $mundur->wali->guru->nama ?? 'Wali Kelas belum di SET'}}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>NIP Wali Kelas</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $mundur->wali->guru->nip ?? 'Wali Kelas belum di SET'}}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Nama Waka Kesiswaan</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $mundur->kesiswaan->guru->nama ?? 'Kesiswaan belum di SET'}}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>NIP Waka Kesiswaan</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $mundur->kesiswaan->guru->nip ?? 'Kesiswaan belum di SET'}}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Guru Konseling</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $mundur->konselor->guru->nama ?? 'Guru Konseling belum di SET'}}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>NIP/NIY Guru Konseling</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $mundur->konselor->guru->nip ?? 'Guru Konseling belum di SET'}}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Kepala Sekolah</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $mundur->kepsek->guru->nama ?? 'Kepsek belum di SET'}}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>NIP Kepala Sekolah</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $mundur->kepsek->guru->nip ?? 'Kepsek belum di SET'}}</b></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="card-footer">
                    <div >
                        <form action="{{ url($url) }}/delete/{{ $mundur->kode_unik }}" method="POST"> @csrf @method('delete')
                            <input type="submit" value="delete" class="btn btn-sm btn-primary float-end" onclick="return confirm('Apakah anda yakin mau hapus ?')">
                        </form>
                        <a href="{{ url("$url/" . $mundur->kode_unik, []) }}/download" class="btn btn-sm btn-primary float-end">unduh</a>
                        <a href="{{ url("$url/" . $mundur->kode_unik, []) }}/edit" class="btn btn-sm btn-primary float-end">edit</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

    @push('scripts')
    @endpush

@endsection