@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman</h3>
        @endslot
        <li class="breadcrumb-item">Halaman</li>
        <li class="breadcrumb-item active">Edit</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-6">
                            <h5 class="card-title">{{ $page }}</h5>
                        </div>
                        <div class="col-lg-6">
                            <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">Kembali</a>
                        </div>
                    </div>
                </div>
                    <form action="{{ url($url) }}/update/{{ $daftar_pt->kode_unik }}" method="POST">
                        @csrf 
                        @method('PUT')

                        <div class="card-body">
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Jurusan</label>
                                <input name="isian_alasan" class="form-control" type="text" value="{{ $daftar_pt->kelasKode->jurusan->nama }}" disabled>
                            </div>
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Kelas</label>
                                <input name="isian_alasan" class="form-control" type="text" value="{{ $daftar_pt->kelasKode->kelas->nama }}" disabled>
                            </div>
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Kode Kelas</label>
                                <input name="isian_alasan" class="form-control" type="text" value="{{ $daftar_pt->kelasKode->nama }}" disabled>
                            </div>
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Siswa</label>
                                <input name="isian_alasan" class="form-control" type="text" value="{{ $daftar_pt->siswa->nama }}" disabled>
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">No Surat</label>
                                <input name="nomor" class="form-control" type="text" value="{{ $daftar_pt->nomor }}">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Tempat</label>
                                <input name="surat_tempat" class="form-control" type="text" value="{{ $daftar_pt->surat_tempat }}">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Tanggal Surat</label>
                                <input name="surat_waktu" class="form-control" type="date" value="{{ $daftar_pt->surat_waktu }}">
                            </div>
                            <div class="email-wrapper">
                                <div class="form-group">
                                    <label>Keterangan</label>
                                    <textarea id="editor1" name="isian_keterangan" cols="10" rows="2">{{ $daftar_pt->isian_keterangan }}</textarea>
                                </div>
                            </div>
                        </div>                
                        <div class="card-footer">
                            <input type="submit" class="btn btn-primary" value="Simpan">
                            <input type="reset" class="btn btn-secondary" value="Cancel">
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script src="{{ asset('assets/js/editor/ckeditor/ckeditor.js') }}"></script>
        <script src="{{ asset('assets/js/editor/ckeditor/adapters/jquery.js') }}"></script>
        <script src="{{ asset('assets/js/editor/ckeditor/styles.js') }}"></script>
        <script src="{{ asset('assets/js/editor/ckeditor/ckeditor.custom.js') }}"></script>
    @endpush

@endsection
