@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/select2.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/select2.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman</h3>
        @endslot
        <li class="breadcrumb-item">Halaman</li>
        <li class="breadcrumb-item active">List</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                  <div class="card-header">
                    <div class="row">
                        <div class="col-lg-6">
                            <h5 class="card-title">{{ $page }}</h5>
                        </div>
                        <div class="col-lg-6">
                            <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">Kembali</a>
                        </div>
                    </div>
                </div>
                    <form action="{{ url($url) }}/store" method="POST">
                        @csrf 
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Kelas</label>
                                <select id="select-kodekelas" class="form-select select2" name="idPKKode" aria-label="Default select example" required>
                                    <option value="">Pilih Kelas Terlebih Dahulu</option>
                                </select >
                            </div>
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Siswa</label>
                                <select id="select-siswa" class="form-select select2" name="idSiswa" aria-label="Default select example" required>
                                    <option value="">Pilih Kode Kelas Terlebih Dahulu</option>
                                </select >
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">No Surat</label>
                                <input name="nomor" class="form-control" type="text" placeholder="Nomor Surat">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Tempat</label>
                                <input name="surat_tempat" class="form-control" type="text" placeholder="Tempat">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Tanggal Surat</label>
                                <input name="surat_waktu" class="form-control" type="date" placeholder="Tanggal Surat">
                            </div>
                            <div class="email-wrapper">
                                  <div class="form-group">
                                    <label>Keterangan</label>
                                    <textarea class="form-control" name="isian_keterangan" cols="10" rows="2"></textarea>
                                  </div>
                            </div>
                        </div>                
                        <div class="card-footer">
                            <input type="submit" class="btn btn-primary" value="Simpan">
                            <input type="reset" class="btn btn-secondary" value="Cancel">
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
        <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
        <script src="{{ asset('assets/js/editor/ckeditor/ckeditor.js') }}"></script>
        <script src="{{ asset('assets/js/editor/ckeditor/adapters/jquery.js') }}"></script>
        <script src="{{ asset('assets/js/editor/ckeditor/styles.js') }}"></script>
        <script src="{{ asset('assets/js/editor/ckeditor/ckeditor.custom.js') }}"></script>
        <script src="{{ asset('assets/js/select2/select2.full.min.js') }}"></script>
        <script src="{{ asset('assets/js/select2/select2-custom.js') }}"></script>
        <script>
            $("#isi-tabel").DataTable(); // tambahin ini ki

            let baseUrl     = '{{ url('') }}';
            $('#tabel-jquery').hide();
        </script>
        
        @include('admin.filter.kelaskomplit')
        @include('admin.filter.siswaKonselorKelas')
    @endpush

@endsection


