@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman Detail</h3>
        @endslot
        <li class="breadcrumb-item">Detail</li>
        <li class="breadcrumb-item active">Data</li>
    @endcomponent
<div class="container-fluid pt-4">
                    
    <div class="row justify-content-center">
        <div class="col-lg-10 col-sm-12">
            <div class="card border-top border-0 border-4 border-info">
                <div class="card-header p-3">
                    <div class="row">
                        <div class="col-lg-6">
                            <h5 class="card-title">{{ $page }}</h5>
                        </div>
                        <div class="col-lg-6">
                            <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">kembali</a>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <table id="datatable" class="table text-center">
                        <tbody>
                            <tr>
                                <td class="text-sm-end">Nama Siswa</td>
                                <td>:</td>
                                <td class="text-sm-start">{{ $siswa->nama }}</td>
                            </tr>
                            <tr>
                                <td class="text-sm-end">NISN</td>
                                <td>:</td>
                                <td class="text-sm-start">{{ $siswa->nisn }}</td>
                            </tr>
                            <tr>
                                <td class="text-sm-end">Kode Kelas</td>
                                <td>:</td>
                                <td class="text-sm-start">{{ $siswa->kelaskode->kelas->nama.' '.$siswa->kelaskode->kelas->jurusan->nama.' '.$siswa->kelaskode->nama }}</td>
                            </tr>
                            <tr>
                                <td class="text-sm-end">Tanggal Lahir</td>
                                <td>:</td>
                                <td class="text-sm-start">{{ $siswa->lahir_tanggal ?? 'tanggal lahir tidak ditemukan' }}</td>
                            </tr>
                            <tr>
                                <td class="text-sm-end">Nama Orang Tua</td>
                                <td>:</td>
                                @if ($ortu == NULL)
                                    <td class="text-sm-start">Data Ortu tidak ditemukan</td>
                                @else
                                <td class="text-sm-start">{{ $ortu->nama }} <a href="{{ url("sekolah/ortu/" . $siswa->id, []) }}" ><i class="fa fa-info-circle"></i></a></td>
                                @endif
                            </tr>
                            <tr>
                                <td class="text-sm-end">Nama Wali</td>
                                <td>:</td>                          
                                <td class="text-sm-start">{{ $sekolah_wali ? $sekolah_wali->guru->nama : 'Wali Kelas Belum Ada' }}</td>
                            </tr>
                            <tr>
                                <td class="text-sm-end">Nama Guru Konseling</td>
                                <td>:</td>                          
                                <td class="text-sm-start">{{ $gurukonselor ? $gurukonselor->guru->nama : 'Konseling Belum Ada' }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                    <table class="display" id="tabel-ygy">
                        <thead>
                            <tr>
                                <th width="50">No.</th>
                                <th>Tanggal</th>
                                <th>NISN</th>
                                <th>Nama</th>
                                <th>Kelas</th>
                                <th>Orang Tua</th>
                                <th>Konseling</th>
                                <th>Masalah</th>
                                <th>Analisa</th>
                                <th>Tindakan</th>
                                <th>Hasil</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($mutasiPembinaan as $r)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $r->isian_tanggal }}</td>
                                    <td>{{ $r->siswa->nisn }}</td>
                                    <td>{{ $r->siswa->nama }}</td>
                                    <td>{{ $r->siswa->kelaskode->kelas->nama.' '.$r->siswa->kelaskode->kelas->jurusan->nama.' '.$r->siswa->kelaskode->nama }}</td>
                                    <td>{{ $r->ortu->nama }}</td>
                                    <td>{{ $r->konselor->guru->nama }}</td>
                                    <td>{{ $r->isian_masalah }}</td>
                                    <td>{{ $r->isian_analisa }}</td>
                                    <td>{{ $r->isian_tindakan }}</td>
                                    <td>{{ $r->isian_hasil }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
    <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatable-extension/dataTables.bootstrap4.min.js') }}"></script>

    <!-- Buttons examples -->
    <script src="{{ asset('assets/js/datatable/datatable-extension/dataTables.buttons.min.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatable-extension/buttons.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatable-extension/jszip.min.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatable-extension/pdfmake.min.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatable-extension/vfs_fonts.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatable-extension/buttons.html5.min.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatable-extension/buttons.print.min.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatable-extension/buttons.colVis.min.js') }}"></script>

    <!-- Responsive examples -->
    <script src="{{ asset('assets/js/datatable/datatable-extension/dataTables.responsive.min.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatable-extension/responsive.bootstrap4.min.js') }}"></script>
    
    <script>
        // $("#tabel-ygy").DataTable();
        $("#tabel-ygy").DataTable({
            responseive:  true,
            paging: false,
            autoWidth: false,
            processing: true,
            dom: 'Bfrtip',
            buttons: [
                'copy', 'excel', 'pdf', 'colvis'
            ]
        });
    </script>
@endpush

@endsection
