@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman Detail</h3>
        @endslot
        <li class="breadcrumb-item">Detail</li>
        <li class="breadcrumb-item active">Data</li>
    @endcomponent

    <div class="row">
        <div class="col-sm-12">
            {{-- Diberikan alert --}}
            @if (session()->has('sukses'))
                <div class="alert alert-success" role="alert">
                    {{ session('sukses') }}
                </div>
            @elseif (session()->has('gagal'))
                <div class="alert alert-danger" role="alert">
                    {{ session('gagal') }}
                </div>
            @endif
            <div class="card">
                <div class="card-header p-3">
                    <div class="row">
                        <div class="col-lg-6">
                            {{-- Kalo di laravel, ada fitur kurung kurawal 2 kali untuk echo --}}
                            <h5 class="card-title">{{ $page }}</h5>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                    <table class="display" id="basic-1">
                        <thead>
                            <tr>
                                <th>Siswa</th>
                                <th>Tanggal Surat</th>
                                <th>Catatan</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>{{ $konrpl->konkegiatan->siswa->nama }}</td>
                                <td>{{ $konrpl->surat_waktu }}</td>
                                <td>{{ $konrpl->isian_catatan }}</td>
                                <td>
                                    <a href="{{ url($url2)}}/{{ $konrpl->id }}" class="btn btn-primary" title="Ubah Data">Detail</a>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-header p-3">
                    <div class="row">
                        <div class="col-lg-6">
                            <h5>Detail Konferensi Berita Acara</h5>
                        </div>
                        @if ($konkegiatan['status'] == 1)
                            <div class="col-lg-6">
                                <a href="{{ url($url3) }}/create/{{ $konkegiatan->kode_unik }}" class="btn btn-sm btn-primary float-end">Tambah Berita Acara</a>
                            </div>
                        @endif
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                    <table class="display" id="basic-2">
                        <thead>
                            <tr>
                                <th>Siswa</th>
                                <th>Dilaksanakan</th>
                                <th>Catatan</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if ($konkegiatan['status'] == 2)
                                {{-- BERITA ACARA --}}
                                <tr>
                                    <td>{{ $konberitaacara->konkegiatan->siswa->nama }}</td>
                                    <td>{{ $konberitaacara->isian_dilaksanakan }}</td>
                                    <td>{{ $konberitaacara->isian_catatan }}</td>
                                    <td>
                                        <a href="{{ url($url3)}}/{{ $konberitaacara->id }}" class="btn btn-primary" title="Ubah Data">Detail</a>
                                    </td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
        <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
    @endpush

@endsection

