@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/select2.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/select2.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman Detail</h3>
        @endslot
        <li class="breadcrumb-item">Detail</li>
        <li class="breadcrumb-item active">Data</li>
    @endcomponent
    
    <div class="container-fluid">
        <div class="row">
            <form action="{{ url($url) }}/store" method="POST">
                @csrf 
                {{-- Create Kon Kegiatan --}}
                <div class="col-sm-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-lg-6">
                                    <h5 class="card-title">{{ $page }}</h5>
                                </div>
                                <div class="col-lg-6">
                                    <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">Kembali</a>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Kelas</label>
                                <select id="select-kodekelas" class="form-select select2" name="idPKKode" aria-label="Default select example" required>
                                    <option value="">Pilih Kelas Terlebih Dahulu</option>
                                </select >
                            </div>
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Siswa</label>
                                <select id="select-siswa" class="form-select select2" name="idSiswa" aria-label="Default select example" required>
                                    <option value="">Pilih Kelas Terlebih Dahulu</option>
                                </select >
                            </div>
                        </div>
                    </div>
                </div>
                {{-- Create RPL --}}
                <div class="col-sm-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="col-lg-6">
                                <h5>Data RPL</h5>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Kota Surat</label>
                                <input name="surat_tempat" class="form-control" type="text" placeholder="Tempat">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Tanggal Surat</label>
                                <input name="surat_waktu" class="form-control" type="date" placeholder="Tanggal Surat">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Judul Layanan</label>
                                <input name="isian_judul" class="form-control" type="text" placeholder="Judul">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Fungsi Layanan</label>
                                <input name="isian_fungsi" class="form-control" type="text" placeholder="fungsi">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Tujuan Kegiatan</label>
                                <input name="isian_tujuan" class="form-control" type="text" placeholder="Tujuan">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Hasil yang ingin dicapai</label>
                                <input name="isian_hasil" class="form-control" type="text" placeholder="hasil">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Gambaran masalah</label>
                                <input name="isian_gambaran" class="form-control" type="text" placeholder="gambaran">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Tempat Penyelenggara Kegiatan</label>
                                <input name="isian_tempat" class="form-control" type="text" placeholder="tempat diselenggarakan">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Waktu diselenggarakan</label>
                                <input name="isian_waktu" class="form-control" type="text" placeholder="waktu">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Tanggal diselenggarakan</label>
                                <input name="isian_tanggal" class="form-control" type="date" placeholder="Tanggal tanggal diselenggarakan">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Semester</label>
                                <input name="isian_semester" class="form-control" type="text" placeholder="semster">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Penyelenggara</label>
                                <input name="isian_penyelenggara" class="form-control" type="text" placeholder="penyelenggara">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Pihak yang disertakan</label>
                                <input name="isian_pihak" class="form-control" type="text" placeholder="pihak">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Bahan yang dibawa dalam pertemuan</label>
                                <input name="isian_bahan" class="form-control" type="text" placeholder="bahan">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Penggunaan hasil pertemuan</label>
                                <input name="isian_penggunaan" class="form-control" type="text" placeholder="penggunaan">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Rencana penilaian</label>
                                <input name="isian_rencana" class="form-control" type="text" placeholder="rencana">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">catatan</label>
                                <input name="isian_catatan" class="form-control" type="text" placeholder="catatan">
                            </div>
                        </div>
                        <div class="card-footer">
                            <input type="submit" class="btn btn-primary" value="Simpan">
                            <input type="reset" class="btn btn-secondary" value="Cancel">
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    @push('scripts')
        <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
        <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
        <script src="{{ asset('assets/js/editor/ckeditor/ckeditor.js') }}"></script>
        <script src="{{ asset('assets/js/editor/ckeditor/adapters/jquery.js') }}"></script>
        <script src="{{ asset('assets/js/editor/ckeditor/styles.js') }}"></script>
        <script src="{{ asset('assets/js/editor/ckeditor/ckeditor.custom.js') }}"></script>
        <script src="{{ asset('assets/js/select2/select2.full.min.js') }}"></script>
        <script src="{{ asset('assets/js/select2/select2-custom.js') }}"></script>
        <script>
            $("#isi-tabel").DataTable(); // tambahin ini ki

            let baseUrl     = '{{ url('') }}';
            $('#tabel-jquery').hide();
        </script>
        
        @include('admin.filter.kelaskomplit')
        @include('admin.filter.siswaKonselorKelas')
    @endpush

@endsection