@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman Detail</h3>
        @endslot
        <li class="breadcrumb-item">Detail</li>
        <li class="breadcrumb-item active">Data</li>
    @endcomponent
<div class="container-fluid pt-4">
                    
    <div class="row justify-content-center">
        <div class="col-lg-10 col-sm-12">
            <div class="card border-top border-0 border-4 border-info">
                <div class="card-header p-3">
                    <div class="row">
                        <div class="col-lg-6">
                            <h5 class="card-title">{{ $page }}</h5>
                        </div>
                        <div class="col-lg-6">
                            <a href="{{ url($url2) }}/{{ $konberitaacara->konkegiatan->kode_unik }}" class="btn btn-sm btn-primary float-end">kembali</a>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <table id="datatable" class="table text-center">
                        <tbody>
                            <tr>
                                <td class="text-sm-end"><b>Hari Dilakasanakan</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konberitaacara->isian_hari }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Tanggal Dilakasanakan</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konberitaacara->isian_tanggal }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Bulan Dilakasanakan</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konberitaacara->isian_bulan }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Tahun Dilakasanakan</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konberitaacara->isian_tahun }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Dilakasanakan Acara</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konberitaacara->isian_dilaksanakan }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Waktu Mulai</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konberitaacara->isian_pukuld }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Waktu Selesai</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konberitaacara->isian_pukuls }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Ruang Tempat Dilaksanakan</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konberitaacara->isian_ruang }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Nama Siswa</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konberitaacara->konkegiatan->siswa->nama }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>No. Induk Siswa</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konberitaacara->konkegiatan->siswa->nisn }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Kelas Siswa</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konberitaacara->konkegiatan->kelaskode->kelas->nama.' '.$konberitaacara->konkegiatan->kelaskode->kelas->jurusan->nama.' '.$konberitaacara->konkegiatan->kelaskode->nama }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Pihak</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konberitaacara->arrayPihak }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Kasus</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konberitaacara->isian_kasus }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Kasus</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konberitaacara->isian_kasus }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Catatan</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konberitaacara->isian_catatan }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Solusi</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konberitaacara->isian_solusi }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Nama Guru Konseling</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konberitaacara->konselor->guru->nama ?? 'Konseling belum di SET' }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Nip/Niy Guru Konseling</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konberitaacara->konselor->guru->nip ?? 'Konseling belum di SET' }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Nama Kepala Sekolah</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konberitaacara->kepsek->guru->nama ?? 'Kepsek belum di SET' }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Nip Kepala Sekolah</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konberitaacara->kepsek->guru->nip ?? 'Kepsek belum di SET' }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Nama Wali Kelas</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konberitaacara->wali->guru->nama ?? 'Wali belum di SET' }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Nip Wali Kelas</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konberitaacara->wali->guru->nip ?? 'Wali belum di SET' }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Nama Waka Kesiswaan</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konberitaacara->kesiswaan->guru->nama ?? 'Kesiswaan belum di SET' }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Nip Waka Kesiswaan</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konberitaacara->kesiswaan->guru->nip ?? 'Kesiswaan belum di SET' }}</b></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="card-footer">
                    <div >
                        <form action="{{ url($url) }}/download" method="POST">
                            @csrf
                            <input type="hidden" name="id" value="{{ $konberitaacara->id }}"> 
                            <input type="submit" class="btn btn-primary" value="unduh">
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

    @push('scripts')
    @endpush

@endsection