@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman Detail</h3>
        @endslot
        <li class="breadcrumb-item">Detail</li>
        <li class="breadcrumb-item active">Data</li>
    @endcomponent
<div class="container-fluid pt-4">
                    
    <div class="row justify-content-center">
        <div class="col-lg-10 col-sm-12">
            <div class="card border-top border-0 border-4 border-info">
                <div class="card-header p-3">
                    <div class="row">
                        <div class="col-lg-6">
                            <h5 class="card-title">{{ $page }}</h5>
                        </div>
                        <div class="col-lg-6">
                            <a href="{{ url($url2) }}/{{ $konrpl->konkegiatan->kode_unik }}" class="btn btn-sm btn-primary float-end">kembali</a>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <table id="datatable" class="table text-center">
                        <tbody>
                            <tr>
                                <td class="text-sm-end"><b>Tempat Surat</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konrpl->surat_tempat }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Tanggal Surat</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konrpl->surat_waktu }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Nama Guru Konseling</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konrpl->konselor->guru->nama ?? 'Konseling belum di SET' }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Nip/Niy Guru Konseling</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konrpl->konselor->guru->nip ?? 'Konseling belum di SET' }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Nama Kepala Sekolah</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konrpl->kepsek->guru->nama ?? 'Kepsek belum di SET' }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Nip Kepala Sekolah</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konrpl->kepsek->guru->nip ?? 'Kepsek belum di SET' }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Judul Layanan</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konrpl->isian_judul }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Fungsi Layanan</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konrpl->isian_fungsi }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Tujuan Layanan</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konrpl->isian_tujuan }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Hasil yang akan dicapai</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konrpl->isian_hasil }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Nama Siswa</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konrpl->konkegiatan->siswa->nama }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Gambaran Masalah</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konrpl->isian_gambaran }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Tempat Diselenggarakan</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konrpl->isian_tempat }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Waktu Diselenggarakan</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konrpl->isian_waktu }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Tanggal Diselenggarakan</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konrpl->isian_tanggal }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Semester</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konrpl->isian_semester }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Penyelenggara Kegiatan</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konrpl->isian_penyelenggara }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Pihak yang disertakan</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konrpl->isian_pihak }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Bahan yang sediakan</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konrpl->isian_bahan }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Penggunaan Hasil pertemuan</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konrpl->isian_penggunaan }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Rencana Penilaian</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konrpl->isian_rencana }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Catatan</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $konrpl->isian_catatan }}</b></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="card-footer">
                    <div >
                        {{-- karena pake route web resource, dibuat sama semua urlnya. Ini otomatis ke halaman form --}}
                        <a href="{{ url("$url/" . $konrpl->id, []) }}/download" class="btn btn-sm btn-primary float-end">unduh</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

    @push('scripts')
    @endpush

@endsection