@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/select2.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman Detail</h3>
        @endslot
        <li class="breadcrumb-item">Detail</li>
        <li class="breadcrumb-item active">Data</li>
    @endcomponent
    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">{{ $page }}</h5>
                            </div>
                            <div class="col-lg-6">
                                <a href="{{ url($url2) }}/{{ $homevisit_kegiatan->kode_unik }}" class="btn btn-sm btn-primary float-end">Kembali</a>
                            </div>
                        </div>
                    </div>
                    <form action="{{ url($url) }}/store/{{ $homevisit_kegiatan->id }}" method="POST">
                        @csrf 
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Nama Guru</label>
                                <select class="form-select select2" name="idSGuru" aria-label="Default select example" required>
                                    <option value="">Pilih Guru</option>
                                    @foreach ($guru as $r) 
                                        <option value="{{ $r->id }}">{{ $r->nama }}</option>
                                    @endforeach
                                </select >
                            </div>
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Jabatan</label>
                                <select class="form-select select2" name="idJabatan" aria-label="Default select example" required>
                                    <option value="">Pilih Jabatan</option>
                                    @foreach ($jabatan as $r) 
                                        <option value="{{ $r->id }}">{{ $r->nama }}</option>
                                    @endforeach
                                </select >
                            </div>
                        </div>
                        <div class="card-footer">
                            <input type="submit" class="btn btn-primary" value="Simpan">
                            <input type="reset" class="btn btn-secondary" value="Cancel">
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

@push('scripts')
    <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
    <script src="{{ asset('assets/js/select2/select2.full.min.js') }}"></script>
    <script src="{{ asset('assets/js/select2/select2-custom.js') }}"></script>
    <script src="{{ asset('assets/js/editor/ckeditor/ckeditor.js') }}"></script>
    <script src="{{ asset('assets/js/editor/ckeditor/adapters/jquery.js') }}"></script>
    <script src="{{ asset('assets/js/editor/ckeditor/styles.js') }}"></script>
    <script src="{{ asset('assets/js/editor/ckeditor/ckeditor.custom.js') }}"></script>
    <script src="{{ asset('assets/js/select2/select2.full.min.js') }}"></script>
    <script src="{{ asset('assets/js/select2/select2-custom.js') }}"></script>
    <script>
        $("#isi-tabel").DataTable(); // tambahin ini ki

        let baseUrl     = '{{ url('') }}';
        $('#tabel-jquery').hide();
    </script>
    @include('admin.filter.kelaskomplit')
    @include('admin.filter.siswaKelas')
    <script>
        $('#select-kodekelas').on('change', function() {
            var val1 = this.value;
            $.getJSON(baseUrl+'/api/sekolah/getsekolahwali/'+val1, (result) => {
                if (result.error_code == '0') {
                    let opt = '<option value="">- Pilih Wali Kelas -</option>';
                    $.each(result.data, function(i, item) {
                        opt += '<option value="'+item.id+'">'+item.idSGuru+'</option>';
                    });
                    $("#select-wali").html(opt);
                }else{
                    let opt = '<option value="">- Tidak Bisa -</option>';
                    $("#select-wali").html(opt);
                }
                $("#select-wali").select2({
                    placeholder: "Pilih Wali",
                });
            });
        });
        
        $('#select-siswa').on('change', function() {
            var val1 = this.value;
            $.getJSON(baseUrl+'/api/sekolahkhusus/getortu/'+val1, (result) => {
                if (result.error_code == '0') {
                    let opt = '<option value="">- Pilih Ortu -</option>';
                    $.each(result.data, function(i, item) {
                        opt += '<option value="'+item.id+'">'+item.nama+'</option>';
                    });
                    $("#select-ortu").html(opt);
                }else{
                    let opt = '<option value="">- Tidak Bisa -</option>';
                    $("#select-ortu").html(opt);
                }
                $("#select-ortu").select2({
                    placeholder: "Pilih Ortu",
                });
            });
        });
    </script>
@endpush

@endsection