@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman Detail</h3>
        @endslot
        <li class="breadcrumb-item">Detail</li>
        <li class="breadcrumb-item active">Data</li>
    @endcomponent

    <div class="row">
        <div class="col-sm-12">
            {{-- Diberikan alert --}}
            @if (session()->has('sukses'))
                <div class="alert alert-success" role="alert">
                    {{ session('sukses') }}
                </div>
            @elseif (session()->has('gagal'))
                <div class="alert alert-danger" role="alert">
                    {{ session('gagal') }}
                </div>
            @endif
            <div class="card">
                <div class="card-header p-3">
                    <div class="row">
                        <div class="col-lg-6">
                            <h5 class="card-title">Detail Home Visit RPL</h5>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                    <table class="display" id="basic-1">
                        <thead>
                            <tr>
                                <th>Siswa</th>
                                <th>Tanggal Surat</th>
                                <th>Catatan</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>{{ $homevisit_kegiatan->siswa->nama }}</td>
                                <td>{{ $homevisit_rpl->surat_waktu }}</td>
                                <td>{{ $homevisit_rpl->isian_catatan }}</td>
                                <td>
                                    <a href="{{ url($url2)}}/{{ $homevisit_rpl->homevisitkegiatan->kode_unik }}" class="btn btn-primary" title="Detail">Detail</a>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                    </div>
                </div>
            </div>
                <div class="card">
                    <div class="card-header p-3">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">Detail Home Visit TU</h5>
                            </div>
                            <div class="col-lg-6">
                                @if ($homevisit_kegiatan['status'] == 1)
                                    <a href="{{ url($url3) }}/create/{{ $homevisit_kegiatan->id }}" class="btn btn-sm btn-primary float-end">Buat Homevisit TU</a>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                        <table class="display" id="basic-2">
                            <thead>
                                <tr>
                                    <th>Nama Guru</th>
                                    {{-- <th>NIP</th> --}}
                                    <th>Jabatan</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if ($homevisit_kegiatan['status'] >= 2)
                                    {{-- BERITA ACARA --}}
                                    <tr>
                                        <td>{{ $guru->nama }}</td>
                                        {{-- <td>{{ $guru->nip }}</td> --}}
                                        <td>{{ $jabatan->nama }}</td>
                                        <td>
                                            <a href="{{ url($url3)}}/{{ $homevisit_tu->id }}" class="btn btn-primary" title="Ubah Data">Detail</a>
                                        </td>
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                        </div>
                    </div>
                </div>
    
                <div class="card">
                    <div class="card-header p-3">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">Detail Home Visit Evaluasi</h5>
                            </div>
                            <div class="col-lg-6">
                                @if ($homevisit_kegiatan['status'] == 2)
                                    <a href="{{ url($url4) }}/create/{{ $homevisit_kegiatan->id }}" class="btn btn-sm btn-primary float-end">Buat Homevisit Evaluasi</a>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                        <table class="display" id="basic-3">
                            <thead>
                                <tr>
                                    <th>Nama Konselor</th>
                                    <th>Tanggal Surat</th>
                                    <th>Topik Permasalahan</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if ($homevisit_kegiatan['status'] == 3)
                                    {{-- BERITA ACARA --}}
                                    <tr>
                                        <td>{{ $homevisit_evaluasi->konselor->guru->nama }}</td>
                                        <td>{{ $homevisit_evaluasi->surat_waktu }}</td>
                                        <td>{{ $homevisit_evaluasi->isian_topik }}</td>
                                        <td>
                                            <a href="{{ url($url4)}}/{{ $homevisit_evaluasi->id }}" class="btn btn-primary" title="Detail">Detail</a>
                                        </td>
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                        </div>
                    </div>
                </div>
        </div>
    </div>

    @push('scripts')
        <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
        <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
    @endpush

@endsection
