@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/select2.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/select2.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman Detail</h3>
        @endslot
        <li class="breadcrumb-item">Detail</li>
        <li class="breadcrumb-item active">Data</li>
    @endcomponent

    <div class="container-fluid">
            <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">Tambah Data Home Visit RPL</h5>
                            </div>
                            <div class="col-lg-6">
                                <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">Kembali</a>
                            </div>
                        </div>
                    </div>
                    <form action="{{ url($url) }}/store" method="POST">
                        @csrf 
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Kode Kelas</label>
                                <select id="select-kodekelas" class="form-select select2" name="idPKKode" aria-label="Default select example" required>
                                    <option value="">Pilih Kelas Terlebih Dahulu</option>
                                </select >
                            </div>
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Siswa</label>
                                <select id="select-siswa" class="form-select select2" name="idSiswa" aria-label="Default select example" required>
                                    <option value="">Pilih Kode Kelas Terlebih Dahulu</option>
                                </select >
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Tempat</label>
                                <input name="surat_tempat" class="form-control" type="text" placeholder="Tempat">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Tanggal Surat</label>
                                <input name="surat_waktu" class="form-control" type="date" placeholder="Tanggal Surat">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Judul</label>
                                <input name="isian_judul" class="form-control" type="text" placeholder="Judul">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Bidang</label>
                                <input name="isian_bidang" class="form-control" type="text" placeholder="Bidang">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Fungsi</label>
                                <input name="isian_fungsi" class="form-control" type="text" placeholder="Fungsi">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Tujuan</label>
                                <input name="isian_tujuan" class="form-control" type="text" placeholder="Tujuan">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Hasil</label>
                                <input name="isian_hasil" class="form-control" type="text" placeholder="Hasil">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Gambaran</label>
                                <input name="isian_gambaran" class="form-control" type="text" placeholder="Gambaran">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Rumah yang Dikunjungi</label>
                                <input name="isian_tempat" class="form-control" type="text" placeholder="Rumah yang Dikunjungi">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Waktu</label>
                                <input name="isian_waktu" class="form-control" type="time" placeholder="Waktu">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Tanggal</label>
                                <input name="isian_tanggal" class="form-control" type="date" placeholder="Tanggal">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Semester</label>
                                <input name="isian_semester" class="form-control" type="text" placeholder="Semester">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Petugas</label>
                                <input name="isian_petugas" class="form-control" type="text" placeholder="Petugas">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Anggota</label>
                                <input name="isian_anggota" class="form-control" type="text" placeholder="Anggota">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Keterangan</label>
                                <input name="isian_keterangan" class="form-control" type="text" placeholder="Keterangan">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Hasil Pertemuan</label>
                                <input name="isian_hasilPertemuan" class="form-control" type="text" placeholder="Hasil Pertemuan">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Rencana</label>
                                <input name="isian_rencana" class="form-control" type="text" placeholder="Rencana">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Catatan</label>
                                <input name="isian_catatan" class="form-control" type="text" placeholder="Catatan">
                            </div>
                        </div>
                        <div class="card-footer">
                            <input type="submit" class="btn btn-primary" value="Simpan">
                            <input type="reset" class="btn btn-secondary" value="Cancel">
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

@push('scripts')
    <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
    <script src="{{ asset('assets/js/select2/select2.full.min.js') }}"></script>
    <script src="{{ asset('assets/js/select2/select2-custom.js') }}"></script>
    <script src="{{ asset('assets/js/editor/ckeditor/ckeditor.js') }}"></script>
    <script src="{{ asset('assets/js/editor/ckeditor/adapters/jquery.js') }}"></script>
    <script src="{{ asset('assets/js/editor/ckeditor/styles.js') }}"></script>
    <script src="{{ asset('assets/js/editor/ckeditor/ckeditor.custom.js') }}"></script>
    <script src="{{ asset('assets/js/select2/select2.full.min.js') }}"></script>
    <script src="{{ asset('assets/js/select2/select2-custom.js') }}"></script>
    <script>
        $("#isi-tabel").DataTable(); // tambahin ini ki

        let baseUrl     = '{{ url('') }}';
        $('#tabel-jquery').hide();
    </script>
    @include('admin.filter.kelaskomplit')
    @include('admin.filter.siswaKelas')
    <script>
        $('#select-kodekelas').on('change', function() {
            var val1 = this.value;
            $.getJSON(baseUrl+'/api/sekolah/getsekolahwali/'+val1, (result) => {
                if (result.error_code == '0') {
                    let opt = '<option value="">- Pilih Wali Kelas -</option>';
                    $.each(result.data, function(i, item) {
                        opt += '<option value="'+item.id+'">'+item.idSGuru+'</option>';
                    });
                    $("#select-wali").html(opt);
                }else{
                    let opt = '<option value="">- Tidak Bisa -</option>';
                    $("#select-wali").html(opt);
                }
                $("#select-wali").select2({
                    placeholder: "Pilih Wali",
                });
            });
        });
        
        $('#select-siswa').on('change', function() {
            var val1 = this.value;
            $.getJSON(baseUrl+'/api/sekolahkhusus/getortu/'+val1, (result) => {
                if (result.error_code == '0') {
                    let opt = '<option value="">- Pilih Ortu -</option>';
                    $.each(result.data, function(i, item) {
                        opt += '<option value="'+item.id+'">'+item.nama+'</option>';
                    });
                    $("#select-ortu").html(opt);
                }else{
                    let opt = '<option value="">- Tidak Bisa -</option>';
                    $("#select-ortu").html(opt);
                }
                $("#select-ortu").select2({
                    placeholder: "Pilih Ortu",
                });
            });
        });
    </script>
@endpush

@endsection
