@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/select2.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman Detail</h3>
        @endslot
        <li class="breadcrumb-item">Detail</li>
        <li class="breadcrumb-item active">Data</li>
    @endcomponent
    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">{{ $page }}</h5>
                            </div>
                            <div class="col-lg-6">
                                <a href="{{ url($url2) }}/{{ $homevisit_kegiatan->kode_unik }}" class="btn btn-sm btn-primary float-end">Kembali</a>
                            </div>
                        </div>
                    </div>
                    <form action="{{ url($url) }}/store/{{ $homevisit_kegiatan->id }}" method="POST">
                        @csrf 
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Tempat</label>
                                <input name="surat_tempat" class="form-control" type="text" placeholder="Tempat">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Tanggal Surat</label>
                                <input name="surat_waktu" class="form-control" type="date" placeholder="Tanggal Surat">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Topik Permasalahan</label>
                                <input name="isian_topik" class="form-control" type="text" placeholder="Topik Permasalahan">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Bidang Bimbingan</label>
                                <input name="isian_bidang" class="form-control" type="text" placeholder="Bidang Bimbingan">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Jenis Layanan</label>
                                <input name="isian_jenis" class="form-control" type="text" placeholder="Jenis Layanan">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Fungsi Layanan</label>
                                <input name="isian_fungsi" class="form-control" type="text" placeholder="Fungsi Layanan">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Sasaran Layanan</label>
                                <input name="isian_sasaran" class="form-control" type="text" placeholder="Sasaran Layanan">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Kompetensi Dasar</label>
                                <input name="isian_kompetensi" class="form-control" type="text" placeholder="Kompetensi Dasar">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Tempat Pelaksanaan</label>
                                <input name="isian_tempat" class="form-control" type="text" placeholder="Tempat Pelaksanaan">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Waktu Pelaksanaan</label>
                                <input name="isian_waktu" class="form-control" type="date" placeholder="Waktu">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Deskripsi Tentang Pelayanan</label>
                                <input name="isian_deskripsi" class="form-control" type="text" placeholder="Deskripsi Tentang Pelayanan">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Cara-cara Penilaian</label>
                                <input name="isian_penilaiancara" class="form-control" type="text" placeholder="Cara-cara Penilaian">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Penilaian Proses</label>
                                <input name="isian_penilaianproses" class="form-control" type="text" placeholder="Penilaian Proses">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Penilaian Deskripsi</label>
                                <input name="isian_penilaiandeskripsi" class="form-control" type="text" placeholder="Penilaian Deskripsi">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Cara-cara Penilaian</label>
                                <input name="isian_analisiscara" class="form-control" type="text" placeholder="Cara-cara Penilaian">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Analisis Diagnosis</label>
                                <input name="isian_analisisdiagnostik" class="form-control" type="text" placeholder="Analisis Diagnosis">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Analisis Prognosis</label>
                                <input name="isian_analisisprognosis" class="form-control" type="text" placeholder="Analisis Prognosis">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Analisis Deskripsi</label>
                                <input name="isian_analisisdeskripsi" class="form-control" type="text" placeholder="Analisis Deskripsi">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Tindaklanjut Cara</label>
                                <input name="isian_tindaklanjutcara" class="form-control" type="text" placeholder="Analisis Tindaklanjut">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Tindaklanjut Deskripsi</label>
                                <input name="isian_tindaklanjutdeskripsi" class="form-control" type="text" placeholder="Tindaklanjut Deskripsi">
                            </div>
                        </div>
                        <div class="card-footer">
                            <input type="submit" class="btn btn-primary" value="Simpan">
                            <input type="reset" class="btn btn-secondary" value="Cancel">
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

@push('scripts')
    <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
    <script src="{{ asset('assets/js/select2/select2.full.min.js') }}"></script>
    <script src="{{ asset('assets/js/select2/select2-custom.js') }}"></script>
    <script src="{{ asset('assets/js/editor/ckeditor/ckeditor.js') }}"></script>
    <script src="{{ asset('assets/js/editor/ckeditor/adapters/jquery.js') }}"></script>
    <script src="{{ asset('assets/js/editor/ckeditor/styles.js') }}"></script>
    <script src="{{ asset('assets/js/editor/ckeditor/ckeditor.custom.js') }}"></script>
    <script src="{{ asset('assets/js/select2/select2.full.min.js') }}"></script>
    <script src="{{ asset('assets/js/select2/select2-custom.js') }}"></script>
    <script>
        $("#isi-tabel").DataTable(); // tambahin ini ki

        let baseUrl     = '{{ url('') }}';
        $('#tabel-jquery').hide();
    </script>
    @include('admin.filter.kelaskomplit')
    @include('admin.filter.siswaKelas')
    <script>
        $('#select-kodekelas').on('change', function() {
            var val1 = this.value;
            $.getJSON(baseUrl+'/api/sekolah/getsekolahwali/'+val1, (result) => {
                if (result.error_code == '0') {
                    let opt = '<option value="">- Pilih Wali Kelas -</option>';
                    $.each(result.data, function(i, item) {
                        opt += '<option value="'+item.id+'">'+item.idSGuru+'</option>';
                    });
                    $("#select-wali").html(opt);
                }else{
                    let opt = '<option value="">- Tidak Bisa -</option>';
                    $("#select-wali").html(opt);
                }
                $("#select-wali").select2({
                    placeholder: "Pilih Wali",
                });
            });
        });
        
        $('#select-siswa').on('change', function() {
            var val1 = this.value;
            $.getJSON(baseUrl+'/api/sekolahkhusus/getortu/'+val1, (result) => {
                if (result.error_code == '0') {
                    let opt = '<option value="">- Pilih Ortu -</option>';
                    $.each(result.data, function(i, item) {
                        opt += '<option value="'+item.id+'">'+item.nama+'</option>';
                    });
                    $("#select-ortu").html(opt);
                }else{
                    let opt = '<option value="">- Tidak Bisa -</option>';
                    $("#select-ortu").html(opt);
                }
                $("#select-ortu").select2({
                    placeholder: "Pilih Ortu",
                });
            });
        });
    </script>
@endpush

@endsection
