@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman Detail</h3>
        @endslot
        <li class="breadcrumb-item">Detail</li>
        <li class="breadcrumb-item active">Data</li>
    @endcomponent
<div class="container-fluid pt-4">
                    
    <div class="row justify-content-center">
        <div class="col-lg-10 col-sm-12">
            <div class="card border-top border-0 border-4 border-info">
                <div class="card-header p-3">
                    <div class="row">
                        <div class="col-lg-6">
                            <h5 class="card-title">{{ $page }}</h5>
                        </div>
                        <div class="col-lg-6">
                            <a href="{{ url('konselor/form_ijin/ijin_keluarMasal') }}" class="btn btn-sm btn-primary float-end">kembali</a>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <table id="datatable" class="table text-center">
                        <tbody>
                            <tr>
                                <td class="text-sm-end"><b>Nama Siswa</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $dataIjinKeluarMasal->siswa->nama }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Kelas Siswa</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $dataIjinKeluarMasal->kelaskode->kelas->nama.' '.$dataIjinKeluarMasal->kelaskode->kelas->jurusan->nama.' '.$dataIjinKeluarMasal->kelaskode->nama }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Hari Ijin</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $dataIjinKeluarMasal->isian_hari }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Tanggal Ijin</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $dataIjinKeluarMasal->isian_tanggal }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Pelajaran</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $dataIjinKeluarMasal->isian_pelajaran }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Keterangan</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $dataIjinKeluarMasal->isian_keterangan }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Tempat</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $dataIjinKeluarMasal->surat_tempat }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Tanggal Surat</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $dataIjinKeluarMasal->surat_waktu }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Guru Piket</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $dataIjinKeluarMasal->piket->guru->nama }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>NIP Guru Piket</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $dataIjinKeluarMasal->piket->guru->nip }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Guru Konselor</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $dataIjinKeluarMasal->konselor->guru->nama }}</b></td>
                            </tr><tr>
                                <td class="text-sm-end"><b>NIP Guru Konselor</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $dataIjinKeluarMasal->konselor->guru->nip }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Guru Waka Kurikulum</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $dataIjinKeluarMasal->kurikulum->guru->nama }}</b></td>
                            </tr><tr>
                                <td class="text-sm-end"><b>NIP Waka Kurikulum</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $dataIjinKeluarMasal->kurikulum->guru->nip }}</b></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="card-footer">
                    <div >
                        {{-- karena pake route web resource, dibuat sama semua urlnya. Ini otomatis ke halaman form --}}
                        <a href="{{ url("$url/" . $dataIjinKeluarMasal->kode_unik, []) }}/edit" class="btn btn-sm btn-primary float-end">unduh</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

    @push('scripts')
    @endpush

@endsection