@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman Detail</h3>
        @endslot
        <li class="breadcrumb-item">Detail</li>
        <li class="breadcrumb-item active">Data</li>
    @endcomponent

<div class="container-fluid pt-4">             
    <div class="row justify-content-center">
        <div class="col-lg-10 col-sm-12">
            <div class="card border-top border-0 border-4 border-info">
                <div class="card-header p-3">
                    <div class="row">
                        <div class="col-lg-6">
                            <h5 class="card-title">{{ $page }}</h5>
                        </div>
                        <div class="col-lg-6">
                            <a href="{{ url($url2) }}/{{ $alihtangan_rpl->alihkegiatan->kode_unik }}" class="btn btn-sm btn-primary float-end">kembali</a>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <table id="datatable" class="table text-center">
                        <tbody>
                            <tr>
                                <td class="text-sm-end"><b>Nama</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $alihtangan_rpl->alihkegiatan->siswa->nama }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Kelas</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $alihtangan_rpl->alihkegiatan->kelaskode->kelas->nama.' '.$alihtangan_rpl->alihkegiatan->kelaskode->kelas->jurusan->nama.' '.$alihtangan_rpl->alihkegiatan->kelaskode->nama }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Tempat</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $alihtangan_rpl->surat_tempat }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Tanggal Surat</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $alihtangan_rpl->surat_waktu }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Judul</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $alihtangan_rpl->isian_judul }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Bidang</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $alihtangan_rpl->isian_bidang }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Fungsi</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $alihtangan_rpl->isian_fungsi }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Tujuan</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $alihtangan_rpl->isian_tujuan }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Hasil</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $alihtangan_rpl->isian_hasil }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Gambaran</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $alihtangan_rpl->isian_gambaran }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Dari ke Pada</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $alihtangan_rpl->isian_darikepada }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Alasan</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $alihtangan_rpl->isian_alasan }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Semester</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $alihtangan_rpl->isian_semester }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Bahan</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $alihtangan_rpl->isian_bahan }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Rencana</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $alihtangan_rpl->isian_rencana }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Catatan</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $alihtangan_rpl->isian_catatan }}</b></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="card-footer">
                    <div >
                        {{-- karena pake route web resource, dibuat sama semua urlnya. Ini otomatis ke halaman form --}}
                        <a href="{{ url($url)}}/{{ $alihtangan_rpl->id }}/download" class="btn btn-sm btn-primary float-end">unduh</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

    @push('scripts')
    @endpush

@endsection