@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/select2.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman Detail</h3>
        @endslot
        <li class="breadcrumb-item">Detail</li>
        <li class="breadcrumb-item active">Data</li>
    @endcomponent
    
    <div class="container-fluid">
        <div class="row">
            {{-- Create Kon Kegiatan --}}
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">{{ $page }}</h5>
                            </div>
                            <div class="col-lg-6">
                                <a href="{{ url($url2) }}/{{ $alihtangan_kegiatan->kode_unik }}" class="btn btn-sm btn-primary float-end">Kembali</a>
                            </div>
                        </div>
                    </div>
                    <form action="{{ url($url) }}/store/{{ $alihtangan_kegiatan->id }}" method="POST">
                        @csrf
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Tempat</label>
                                <input name="surat_tempat" class="form-control" type="text" placeholder="Tempat">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Tanggal Surat</label>
                                <input name="surat_waktu" class="form-control" type="date" placeholder="Tanggal Surat">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Kepada</label>
                                <input name="isian_yth" class="form-control" type="text" placeholder="Kepada">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Permasalahan</label>
                                <input name="isian_permasalahan" class="form-control" type="text" placeholder="Permasalahan">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Keterangan</label>
                                <input name="isian_keterangan" class="form-control" type="text" placeholder="Keterangan">
                            </div>
                        </div>
                        <div class="card-footer">
                            <input type="submit" class="btn btn-primary" value="Simpan">
                            <input type="reset" class="btn btn-secondary" value="Cancel">
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

@push('scripts')
    <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
    <script src="{{ asset('assets/js/select2/select2.full.min.js') }}"></script>
    <script src="{{ asset('assets/js/select2/select2-custom.js') }}"></script>
    <script>
        $("#isi-tabel").DataTable(); // tambahin ini ki

        let baseUrl     = '{{ url('') }}';
        $('#tabel-jquery').hide();
    </script>
@endpush

@endsection
