@extends($admin)

@section('title')
    {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
            <h3>Halaman</h3>
        @endslot
        <li class="breadcrumb-item">Halaman</li>
        <li class="breadcrumb-item active">List</li>
    @endcomponent


    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                {{-- Diberikan alert --}}
                @if (session()->has('sukses'))
                    <div class="alert alert-success" role="alert">
                        {{ session('sukses') }}
                    </div>
                @elseif (session()->has('gagal'))
                    <div class="alert alert-danger" role="alert">
                        {{ session('gagal') }}
                    </div>
                @endif
                <div class="card">
                    <div class="card-header p-3">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">{{ $page }}</h5>
                            </div>
                            <div class="col-lg-6">
                                <a href="{{ url($url) }}/create" class="btn btn-sm btn-primary float-end">Import
                                    Siswa</a>
                                <button class="btn btn-sm btn-warning float-end" type="button" data-bs-toggle="modal"
                                    data-bs-target="#exampleModalCenter">Migrasi Data</button>
                                <div class="modal fade" id="exampleModalCenter" tabindex="-1"
                                    aria-labelledby="exampleModalCenter" style="display: none;" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title">Modal title</h5>
                                                <button class="btn-close" type="button" data-bs-dismiss="modal"
                                                    aria-label="Close" data-bs-original-title="" title=""></button>
                                            </div>
                                            <div class="modal-body">
                                                <p>Apakah Anda yakin ingin melakukan migrasi data ?</p>
                                            </div>
                                            <div class="modal-footer">
                                                <button class="btn btn-secondary" type="button" data-bs-dismiss="modal"
                                                    data-bs-original-title="" title="">Batalkan</button>
                                                <button id="migrasiSiswa" class="btn btn-primary" type="button"
                                                    data-bs-original-title="" title="">Migrasi Data Siswa</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="display" id="basic-1">
                                <thead>
                                    <tr>
                                        <th width="50">No.</th>
                                        <th>Periode</th>
                                        <th>NISN</th>
                                        <th>Nama</th>
                                        <th>Waktu Import</th>
                                        <th>Data Admin</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($excelSiswa as $r)
                                        <tr>
                                            <td>{{ $loop->iteration }}</td>
                                            <td>{{ $r->periode->nama_periode }}</td>
                                            <td>{{ $r->nisn }}</td>
                                            <td>{{ $r->nama }}</td>
                                            <td>{{ $r->created_at }}</td>
                                            <td>{{ $r->user->username ?? '-' }}</td>
                                            <td>
                                                @if ($r->status == 1)
                                                    Tambah
                                                @elseif($r->status == 2)
                                                    Edit
                                                @else
                                                    Gagal
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
        <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
        <script>
            $(function() {
                $('#migrasiSiswa').on('click', function() {
                    // let idPSekolah = "{{ session()->get('idPSekolah') }}";
                    // let idPPeriode = "{{ session()->get('idPPeriode') }}";
                    let url = "{{ url($url) }}/migrate";
                    console.log(url);

                    $.ajax({
                        url: url,
                        type: 'POST',
                        data: {
                            // idPSekolah: idPSekolah,
                            // idPPeriode: idPPeriode,
                            _token: "{{ csrf_token() }}" // Pastikan CSRF token disertakan untuk keamanan
                        },
                        success: function(response) {
                            // Tindakan yang diambil jika POST berhasil
                            console.log('Data berhasil dikirim:', response);
                            alert('Migrasi siswa berhasil!');
                        },
                        error: function(xhr, status, error) {
                            // Tindakan yang diambil jika POST gagal
                            console.error('Terjadi kesalahan:', error);
                            alert('Terjadi kesalahan dalam migrasi siswa.');
                        }
                    });
                });
               
            });
        </script>
    @endpush
@endsection
