@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
<link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman</h3>
        @endslot
        <li class="breadcrumb-item">Halaman</li>
        <li class="breadcrumb-item active">List</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                {{-- Diberikan alert --}}
                @if (session()->has('sukses'))
                    <div class="alert alert-success" role="alert">
                        {{ session('sukses') }}
                    </div>
                @elseif (session()->has('gagal'))
                    <div class="alert alert-danger" role="alert">
                        {{ session('gagal') }}
                    </div>
                @endif
                <div class="card">
                    <div class="card-header p-3">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">{{ $page }}</h5>
                            </div>
                            <div class="col-lg-6">
                                <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">Kembali</a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                        <table class="display" id="basic-1">
                            <thead>
                                <tr>
                                    <th width="50">No.</th>
                                    <th>Periode</th>
                                    <th>Waktu Import</th>
                                    <th>Data Admin</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($excelGuru as $r)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $r->periode->nama_periode }}</td>
                                        <td>{{ $r->created_at }}</td>
                                        <td>{{ $r->user->username ?? '-' }}</td>
                                        <td>
                                          <a href="{{ url($url) }}/preview" class="btn btn-sm btn">Lihat Data</a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
        <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
        <script>
            $(function() {
                $("#isi-tabel").DataTable(); // tambahin ini ki

                let baseUrl     = '{{ url('') }}';
                let idSekolah = "{{ session()->get('idsekolah') }}";
                $('#tabel-jquery').hide();
            });
        </script>
    @endpush

@endsection



