@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman</h3>
        @endslot
        <li class="breadcrumb-item">Halaman</li>
        <li class="breadcrumb-item active">List</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">{{ $page }}</h5>
                            </div>
                            <div class="col-lg-6">
                                <a href="{{ url('excel-template/format_input_guru.xlsx') }}" class="btn btn-sm btn-primary float-end">Download Template</a>
                            </div>
                    </div>
                </div>
                </div>
            </div>
            
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row g-2">
            
                            <form action="{{ url($url) }}/store" method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="mb-3 row">
                                    <label class="col-sm-3 col-form-label" for="exampleFormControlTextarea4">Import Excel</label>
                                    <div class="col-sm-9">
                                        <input class="form-control" name="file_excel" type="file" accept=".csv, .xls, .xlsx"> 
                                    </div>
                                </div>    
                                <div>
                                    <div class="text-end btn-mb">
                                        <input type="submit" value="Upload" class="btn btn-primary">
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        
    @endpush

@endsection



