@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/select2.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman List</h3>
        @endslot
        <li class="breadcrumb-item">List</li>
        <li class="breadcrumb-item active">Data</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">

            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">{{ $page }}</h5>
                            </div>
                            <div class="col-lg-6">
                                <a href="{{ url('excel-template/format_input_sekolah.xlsx') }}" class="btn btn-sm btn-primary float-end">Download Template</a>
                            </div>
                    </div>
                </div>
                </div>
            </div>
            
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="col-form-label">Data Daerah</label>
                        </div>
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="col-form-label">Pilih Provinsi</label>
                                <select id="select-provinsi" class="form-select select2" name="idMProvinsi" aria-label="Default select example" required>
                                    <option value="">Pilihan Provinsi Sedang di Proses</option>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label class="col-sm-3 col-form-label">Pilih Daerah</label>
                                    <select id="select-daerah" class="form-select select2" name="idMDaerah" aria-label="Default select example" required>
                                        <option value="">Pilih Provinsi Terlebih Dahulu</option>
                                    </select>
                            </div>
                            <div class="col-md-12">
                                <label class="col-form-label" for="validationCustomUsername">Copy untuk Excel</label>
                                <input id="enDaerah" type="text" class="form-control col-mb-6">
                                <button class="btn btn-primary btn-clipboard-cut" type="button" data-clipboard-action="cut" data-clipboard-target="#enDaerah" data-bs-original-title="" title=""><i class="fa fa-copy"></i> Copy</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row g-2">
                            <div class="col-md-6">
                                <label class="col-form-label">Pilih Periode</label>
                                <select id="select-periode" class="form-select select2" name="idPPeriode" aria-label="Default select example" required>
                                    <option value="">Pilih Periode</option>
                                    @foreach ($periode as $r) 
                                        <option value="{{ enc($r->id) }}">{{ $r->nama_periode }}</option>
                                    @endforeach
                                </select >
                            </div>
                            <div class="col-md-6">
                                <label class="col-form-label" for="validationCustomUsername">Copy untuk Excel</label>
                                <input id="enPeriode" type="text" class="form-control col-mb-6">
                                <button class="btn btn-primary btn-clipboard-cut" type="button" data-clipboard-action="cut" data-clipboard-target="#enPeriode" data-bs-original-title="" title=""><i class="fa fa-copy"></i>Copy</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row g-2">
            
                            <form action="{{ url($url) }}/store" method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="mb-3 row">
                                    <label class="col-sm-3 col-form-label" for="exampleFormControlTextarea4">Import Excel</label>
                                    <div class="col-sm-9">
                                        <input class="form-control" name="file_excel" type="file" accept=".csv, .xls, .xlsx"> 
                                    </div>
                                </div>    
                                <div>
                                    <div class="text-end btn-mb">
                                        <input type="submit" value="Migrasi" class="btn btn-primary">
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    <script src="{{ asset('assets/js/clipboard/clipboard.min.js') }}"></script>
    <script src="{{ asset('assets/js/clipboard/clipboard-script.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
    <script src="{{ asset('assets/js/select2/select2.full.min.js') }}"></script>
    <script src="{{ asset('assets/js/select2/select2-custom.js') }}"></script>
    
    <script>
        $(function() {
            let baseUrl     = '{{ url('') }}';
            let idSekolah = "{{ session()->get('idPSekolah') }}";

            $.getJSON(baseUrl+'/getAllProvinsi', (result) => {
                if (result.error_code == '0') {
                    let opt = '<option value="">- Pilih -</option>';
                    $.each(result.data, function(i, item) {
                        opt += '<option value="'+item.id+'">'+item.nama+'</option>';
                    });
                    $("#select-provinsi").html(opt);
                }else{
                    let opt = '<option value="">- Tidak Bisa -</option>';
                    $("#select-provinsi").html(opt);
                }
                $("#select-provinsi").select2({
                    placeholder: "Pilih Provinsi",
                });
            });

            $('#select-provinsi').on('change', function() {
                var val1 = this.value;
                $.getJSON(baseUrl+'/getProvinsiDaerah/'+val1, (result) => {
                    if (result.error_code == '0') {
                        let opt = '<option value="">- Pilih Daerah -</option>';
                        $.each(result.data, function(i, item) {

                            $.get(baseUrl + '/bantusandi/' +item.id, function(encryptedResponse) {
                                opt += '<option value="' + encryptedResponse.encrypted + '">' + item.nama + '</option>';
                                $("#select-daerah").html(opt);
                            });
                            
                        });
                        $("#select-daerah").html(opt);
                    }else{
                        let opt = '<option value="">- Tidak Bisa -</option>';
                        $("#select-daerah").html(opt);
                    }
                    $("#select-daerah").select2({
                        placeholder: "Pilih Daerah",
                    });
                });
            });

            $("#select-periode").select2({
                placeholder: "Pilih Periode",
            });

            $('#select-daerah').on('change', function() {
                $("#enDaerah").val(this.value);
            });

            $('#select-periode').on('change', function() {
                $("#enPeriode").val(this.value);
            });

        });
    </script>
    @endpush

@endsection
