@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Dashboard</h3>
        @endslot
        {{-- <li class="breadcrumb-item">Dashboard</li>
        <li class="breadcrumb-item active">Sample Page</li> --}}
    @endcomponent

    <div class="container-fluid">
        @if (session()->has('sukses'))
            <div class="alert alert-success" role="alert">
                {{ session('sukses') }}
            </div>
        @elseif (session()->has('gagal'))
            <div class="alert alert-danger" role="alert">
                {{ session('gagal') }}
            </div>
        @endif
        <div class="row justify-content-center">
            <div class="col-lg-10 col-sm-12">
                <div class="card border-top border-0 border-4 border-info">
                    <div class="card-header p-3">
                        <div class="row">
                            <div class="col-lg-6">
                                {{-- Kalo di laravel, ada fitur kurung kurawal 2 kali untuk echo --}}
                                <h5 class="card-title">{{ $page }}</h5>
                            </div>
                            <div class="col-lg-6">
                                {{-- karena pake route web resource, dibuat sama semua urlnya. Ini otomatis ke halaman form --}}
                                {{-- <a href="{{ url('sekolah/profil') }}" class="btn btn-sm btn-primary float-end">kembali</a> --}}
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <table id="datatable" class="table text-center">
                            <tbody>
                                @if (session()->get('role') == 1)
                                    <tr>
                                        <td class="text-sm-end">Username</td>
                                        <td>:</td>
                                        <td class="text-sm-start">{{ $user->username }}</td>
                                    </tr>
                                @elseif (session()->get('role') == 2 || session()->get('role') == 3)
                                    <tr>
                                        <td class="text-sm-end"><b>Sekolah</b></td>
                                        <td>:</td>
                                        <td class="text-sm-start"><b> {{ $user->sekolah->nama }} </b></td>
                                    </tr>
                                    <tr>
                                        <td class="text-sm-end">Alamat</td>
                                        <td>:</td>
                                        <td class="text-sm-start">{{ $user->sekolah->alamat }}</td>
                                    </tr>
                                    <tr>
                                        <td class="text-sm-end">NPSN</td>
                                        <td>:</td>
                                        <td class="text-sm-start">{{ $user->username }}</td>
                                    </tr>
                                @endif
                                <tr>
                                    <td class="text-sm-end"></td>
                                    <td><a href="{{ url($url) }}/update-password" class="btn btn-primary">Update Password</a></td>
                                    <td class="text-sm-start"></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
    @push('scripts')
    @endpush

@endsection