@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Dashboard</h3>
        @endslot
        {{-- <li class="breadcrumb-item">Dashboard</li>
        <li class="breadcrumb-item active">Sample Page</li> --}}
    @endcomponent
    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                @if (session()->has('sukses'))
                    <div class="alert alert-success" role="alert">
                        {{ session('sukses') }}
                    </div>
                @elseif (session()->has('gagal'))
                    <div class="alert alert-danger" role="alert">
                        {{ session('gagal') }}
                    </div>
                @endif
                <div class="card">
                  <div class="card-header">
                    <div class="row">
                        <div class="col-lg-6">
                            <h5 class="card-title">{{ $page }}</h5>
                        </div>
                        <div class="col-lg-6">
                            <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">Kembali</a>
                        </div>
                    </div>
                </div>
                    <form action="{{ url($url) }}/update" method="post">
                        @csrf
                        @method('PUT')
                        <div class="card-body">
                            <div class="form-group">
                                @if (session()->get('role') == 2 || session()->get('role') == 3)
                                    <div class="mb-3">
                                        <label class="col-form-label pt-0" for="exampleInputEmail1">Sekolah</label>
                                        <input name="idPSekolah" class="form-control" type="text" disabled value="{{ $user->sekolah->nama }}">
                                    </div>
                                @endif
                                <div class="mb-3">
                                    <label class="col-form-label pt-0" for="exampleInputEmail1">Username</label>
                                    <input name="username" class="form-control" type="text" disabled value="{{ $user->username }}">
                                </div>
                                <div class="mb-3">
                                    <label class="col-form-label pt-0" for="exampleInputEmail1">Password Lama</label>
                                    <input name="password" class="form-control" type="password" placeholder="Masukkan password">
                                    {{-- penempatan name selalu sebelah input ya, biar gampang di cek --}}
                                </div>
                                <div class="mb-3">
                                    <label class="col-form-label pt-0" for="exampleInputEmail1">Password Baru</label>
                                    <input name="password_new" class="form-control" type="password" placeholder="Masukkan Password Baru">
                                    {{-- penempatan name selalu sebelah input ya, biar gampang di cek --}}
                                </div>
                                <div class="mb-3">
                                    <label class="col-form-label pt-0" for="exampleInputEmail1">Ulangi Password Baru</label>
                                    <input name="password_verif" class="form-control" type="password" placeholder="Ulangi Password Baru">
                                    {{-- penempatan name selalu sebelah input ya, biar gampang di cek --}}
                                </div>
                            </div>
                                <div class="form-group mt-3">
                                    <button type="submit" class="btn btn-primary">Simpan</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    
    @push('scripts')
    @endpush

@endsection