<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\URL;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        if (env('HTTPS') == 'true') {
            $this->app['request']->server->set('HTTPS','on');
            URL::forceScheme('https');
        }

        $project_title = '| Viho - Premium Admin Template';
        View::share('title', $project_title);

        view()->share('landing', 'layouts/landing/main');
        view()->share('auth', 'layouts/admin/auth/master');
        view()->share('admin', 'layouts/admin/master');

        // view()->share('sekolah', 'adminSekolah/layout/main');
        // view()->share('konselor', 'adminKonselor/layout/main');
    }
}
