<?php

namespace App\Models\User;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

// Library
use DB;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserUsulanmodel extends Model
{
    // softdelete itu untuk fitur dari laravel. User hapus, data untuk user hilang tapi di tabel tidak hilang. cuma di hiden
    use HasFactory, SoftDeletes;

    // Nama tabel
    protected $table = 'user_usulan';
    protected $guarded = ['id'];


    public function daerah()
    {
        return $this->belongsTo(\App\Models\Master\DaerahModel::class, 'idMDaerah', 'id');
    }

    public function periode()
    {
        return $this->belongsTo(\App\Models\Master\PeriodeModel::class, 'idPPeriode', 'id');
    }
}
