<?php

namespace App\Models\Siswa;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

// Library
use DB;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrtuModel extends Model
{
    // softdelete itu untuk fitur dari laravel. User hapus, data untuk user hilang tapi di tabel tidak hilang. cuma di hiden
    use HasFactory, SoftDeletes;

    // Nama tabel
    protected $table = 'ortu';
    protected $guarded = ['id'];

    public function siswa()
    {
        return $this->belongsTo(SiswaModel::class, 'idSiswa', 'id');
    }

    public function pekerjaan()
    {
        return $this->belongsTo(\App\Models\Master\PekerjaanModel::class, 'idMPekerjaan', 'id');
    }
}
