<?php

namespace App\Models\Perpus;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

// Library
use DB;
use Illuminate\Database\Eloquent\SoftDeletes;

class SekolahModel extends Model
{
   // softdelete itu untuk fitur dari laravel. User hapus, data untuk user hilang tapi di tabel tidak hilang. cuma di hiden
   use HasFactory, SoftDeletes;

   // Nama tabel
   protected $table = 'perpus_sekolah';
   protected $guarded = ['id'];

   public function daerah()
    {
        return $this->belongsTo(\App\Models\Master\DaerahModel::class, 'idMDaerah', 'id');
    }

    public function kelas()
    {
        return $this->belongsTo(\App\Models\Perpus\KelasModel::class, 'idPKelas', 'id');
    }

    public function jurusan()
    {
        return $this->hasMany(\App\Models\Perpus\JurusanModel::class, 'idPSekolah', 'id');
    }

    public function periode()
    {
        return $this->belongsTo(\App\Models\Master\PeriodeModel::class, 'idPPeriode', 'id');
    }
    
    public function jenisSekolah()
    {
        return $this->belongsTo(\App\Models\Master\JenisSekolahModel::class, 'idJSekolah');
    }

    public function siswa()
    {
        return $this->hasMany(\App\Models\Siswa\SiswaModel::class, 'idPSekolah');
    }
}
