<?php

namespace App\Models\Perpus;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

// Library
use DB;
use Illuminate\Database\Eloquent\SoftDeletes;

class KelasKodeModel extends Model
{
    // softdelete itu untuk fitur dari laravel. User hapus, data untuk user hilang tapi di tabel tidak hilang. cuma di hiden
    use HasFactory, SoftDeletes;

    // Nama tabel
    protected $table = 'perpus_kelasKode';
    protected $guarded = ['id'];

    public function sekolah()
    {
        return $this->belongsTo(SekolahModel::class, 'idPSekolah', 'id');
    }

    public function jurusan()
    {
        return $this->belongsTo(JurusanModel::class, 'idPJurusan', 'id');
    }

    public function kelas()
    {
        return $this->belongsTo(KelasModel::class, 'idPKelas', 'id');
    }

    public function walikelas()
    {
        return $this->belongsTo(\App\Models\Stakeholder\SekolahWaliModel::class, 'idSWali', 'id');
    }

    public function jmlSiswa()
    {
        return $this->hasMany(\App\Models\Siswa\SiswaModel::class, 'idPKKode', 'id');
    }

    public function periode_kelas()
    {
        return $this->hasMany(\App\Models\Siswa\SiswaModel::class, 'idPKKode', 'id')->where('idPPKelas', 0);
    }

    public function periode_status()
    {
        return $this->hasMany(\App\Models\Siswa\SiswaModel::class, 'idPKKode', 'id')->where('idPPStatus', 0);
    }
}
