<?php

namespace App\Models\Layanan\Surat;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

// Library
use DB;
use Illuminate\Database\Eloquent\SoftDeletes;

class DaftarPTModel extends Model
{
    use HasFactory, SoftDeletes;

    // Nama tabel
    protected $table = 'layanan_surat_daftarpt';
    protected $guarded = ['id'];

    public function periode()
    {
        return $this->belongsTo(\App\Models\Master\PeriodeModel::class, 'idPPeriode', 'id');
    }
    
    public function kelas()
    {
        return $this->belongsTo(\App\Models\Perpus\KelasModel::class, 'idPKelas', 'id');
    }

    public function kelasKode()
    {
        return $this->belongsTo(\App\Models\Perpus\KelasKodeModel::class, 'idPKKode', 'id');
    }

    public function kepsek()
    {
        return $this->belongsTo(\App\Models\Stakeholder\KepsekModel::class, 'idSKepsek', 'id');
    }

    public function kesiswaan()
    {
        return $this->belongsTo(\App\Models\Stakeholder\WakaKesiswaanModel::class, 'idSKesiswaan', 'id');
    }

    public function konselor()
    {
        return $this->belongsTo(\App\Models\Stakeholder\KonselorModel::class, 'idSKonselor', 'id');
    }

    public function wali()
    {
        return $this->belongsTo(\App\Models\Stakeholder\SekolahWaliModel::class, 'idSWali', 'id');
    }

    public function siswa()
    {
        return $this->belongsTo(\App\Models\Siswa\SiswaModel::class, 'idSiswa', 'id');
    }

    public function ortu()
    {
        return $this->belongsTo(\App\Models\Siswa\OrtuModel::class, 'idOrtu', 'id');
    }
}
