<?php

namespace App\Models\ImportDapodik;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

// Library
use DB;
use Illuminate\Database\Eloquent\SoftDeletes; 

class ImportExcelGuruModel extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'importexceldapodik_guru';
    protected $guarded = ['id'];


    public function sekolah()
    {
        return $this->belongsTo(\App\Models\Perpus\SekolahModel::class, 'idPSekolah', 'id');
    }

    public function periode()
    {
        return $this->belongsTo(\App\Models\Master\PeriodeModel::class, 'idPPeriode', 'id');
    }

    public function user()
    {
        return $this->belongsTo(\App\Models\User\UserModel::class, 'idUser', 'id');
    }
}
