<?php

namespace App\Libraries\ShouldQueue;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Http\Request;

use App\Models\Import\DapodikGuruModel;
use App\Models\Import\DapodikSiswaModel;

use App\Models\User\UserModel;
use App\Models\Stakeholder\GuruModel;
use App\Models\Stakeholder\KonselorModel;
use App\Models\Perpus\SekolahModel;

class MigrateTransaksi
{
      public static function migrasiGuru()
      {
            $dataGuruTemp = DapodikGuruModel::select([
                  'nama',
                  'nip',
                  'jenis_ptk',
                  'hp',
                  'email',
            ])->get();

            $importResults = [
                  'guru_mapel'    => ['berhasil' => 0, 'gagal' => 0],
                  'guru_bk'       => ['berhasil' => 0, 'gagal' => 0],
            ];

            $dataGuruTemp->map(function ($guru) use (&$importResults) {
                  $existingGuru = DB::table('dummy_sekolah_guru')->where('nip', $guru->nip)->first();
                  if ($guru->jenis_ptk == 'Guru Mapel') {
                        if (!$existingGuru) {
                              $data_arr = [
                                    'idPSekolah'    => 1, // dummy
                                    'idMapel'       => 99,
                                    'nip'           => $guru->nip ?? '-',
                                    'telp'          => $guru->hp ?? '-',
                                    'email'         => $guru->email ?? '-',
                                    'status'        => 1,
                              ];
                              try {
                                    DB::table('dummy_sekolah_guru')->insert([
                                          'idPSekolah'    => 1, // dummy
                                          'idMapel'       => 99,
                                          'nip'           => $guru->nip ?? '-',
                                          'telp'          => $guru->hp ?? '-',
                                          'email'         => $guru->email ?? '-',
                                          'status'        => 1,
                                    ]);

                                    $importResults['guru_mapel']['berhasil']++;
                              } catch (\Exception $e) {
                                    $importResults['guru_mapel']['gagal']++;
                              }
                        } else {
                              $importResults['guru_mapel']['gagal']++;
                        }
                  } elseif ($guru->jenis_ptk == 'Guru BK') {
                        if (!$existingGuru) {
                              try {
                                    $guruImport = DB::table('dummy_sekolah_guru')->insertGetId([
                                          'idPSekolah'    => 1, // dummy
                                          'idMapel'       => 99,
                                          'nip'           => $guru->nip ?? '-',
                                          'telp'          => $guru->hp ?? '-',
                                          'email'         => $guru->email ?? '-',
                                          'status'        => 1,
                                    ]);

                                    $konselorImport = DB::table('dummy_sekolah_konselor')->insertGetId([
                                          'idPSekolah'    => 1, // dummy
                                          'idSGuru'       => $guruImport,
                                          'status'        => 1,
                                    ]);

                                    $sekolah = SekolahModel::where('id', 1)->first();

                                    DB::table('dummy_users')->insert([
                                          'username'      => $guru->email,
                                          'password'      => bcrypt("bkpeduli"),
                                          'sandi'         => "bkpeduli", // dummy
                                          'status'        => 1,
                                          'idPSekolah'    => 1, // dummy
                                          'role'          => 3, // konselor
                                          'idSKonselor'   => $konselorImport,
                                          'idPPeriode'    => $sekolah->idPPeriode,
                                          'telp'          => $guru->hp ?? '-',
                                    ]);

                                    $importResults['guru_bk']['berhasil']++;
                              } catch (\Exception $e) {
                                    $importResults['guru_bk']['gagal']++;
                              }
                        } else {
                              $importResults['guru_bk']['gagal']++;
                        }
                  }
            });

            return response()->json([
                  'message' => 'Proses import selesai',
                  'hasil' => $importResults,
            ]);
      }

      public static function migrasiDapodikSiswa()
      {
            $dataPesertaDidik = DapodikSiswaModel::select([
                  'idPSekolah',
                  'nama',
                  'nisn',
                  'tempat_lahir',
                  'tanggal_lahir',
                  'agama',
                  'alamat',
                  'rt',
                  'rw',
                  'dusun',
                  'kelurahan',
                  'kecamatan',
                  'kode_pos',
                  'jenis_tinggal',
                  'telepon',
                  'hp',
                  'email',
                  'nama_ayah',
                  'pekerjaan_ayah',
                  'rombel_saat_ini'
            ])->get();

            $importResults = [
                  'import_tingkat'        => ['berhasil' => 0, 'gagal' => 0],
                  'import_jurusan'        => ['berhasil' => 0, 'gagal' => 0],
                  'import_index'          => ['berhasil' => 0, 'gagal' => 0],
                  'import_siswa'          => ['berhasil' => 0, 'gagal' => 0],
                  'import_siswa_mutasi'   => ['berhasil' => 0, 'gagal' => 0],
                  'import_siswa_ortu'     => ['berhasil' => 0, 'gagal' => 0],
            ];

            $sekolah = DB::table('perpus_sekolah')->where('id', 1)->first(); // dummy 1 diganti id sekolah

            $dataPesertaDidik->map(function ($peserta) use (&$importResults, $sekolah) {

                  try {
                        // Pastikan kolom rombel_saat_ini valid
                        if (!$peserta->rombel_saat_ini) {
                              throw new \Exception("Rombel tidak ditemukan");
                        }

                        list($kelas, $jurusan, $kodeKelas) = explode('-', $peserta->rombel_saat_ini);

                        // Pengecekan jurusan
                        try {
                              $jurusanId = DB::table('dummy_perpus_jurusan')->where('nama', $jurusan)->value('id');
                              if (!$jurusanId) {
                                    $jurusanId = DB::table('dummy_perpus_jurusan')->insertGetId([
                                          'idPSekolah'    => 1, // dummy
                                          'nama'          => $jurusan,
                                    ]);
                                    $importResults['import_jurusan']['berhasil']++;
                              }
                        } catch (\Exception $e) {
                              echo json_encode($e);
                              die;
                              $importResults['import_jurusan']['gagal']++;
                        }

                        // Pengecekan tingkat/kelas
                        try {
                              $kelasId = DB::table('dummy_perpus_kelas')->where('nama', $kelas)->value('id');
                              if (!$kelasId) {
                                    $kelasId = DB::table('dummy_perpus_kelas')->insertGetId([
                                          'idPSekolah'    => 1, // dummy
                                          'idPJurusan'    => $jurusanId,
                                          'nama'          => $kelas,
                                    ]);
                                    $importResults['import_tingkat']['berhasil']++;
                              }
                        } catch (\Exception $e) {
                              echo json_encode($e);
                              die;
                              $importResults['import_tingkat']['gagal']++;
                        }

                        // Pengecekan kode kelas
                        try {
                              $kelasKodeId = DB::table('dummy_perpus_kelasKode')->where([
                                    ['nama', '=', $kodeKelas],
                                    ['idPSekolah', '=', 1], // dummy
                                    ['idPJurusan', '=', $jurusanId],
                                    ['idPKelas', '=', $kelasId],
                              ])->value('id');
                              if (!$kelasKodeId) {
                                    $kelasKodeId = DB::table('dummy_perpus_kelasKode')->insertGetId([
                                          'idPSekolah'    => 1, // dummy
                                          'idPJurusan'    => $jurusanId,
                                          'idPKelas'      => $kelasId,
                                          'nama'          => $kodeKelas,
                                    ]);
                                    $importResults['import_index']['berhasil']++;
                              }
                        } catch (\Exception $e) {
                              echo json_encode($e);
                              die;
                              $importResults['import_index']['gagal']++;
                        }

                        // Cek apakah siswa sudah ada
                        try {
                              $existingSiswa = DB::table('dummy_siswa')->where('nisn', $peserta->nisn)->first();

                              if (!$existingSiswa) {
                                    $alamatLengkap = $peserta->alamat . ', RT: ' . ($peserta->rt ?? '-') . ', RW: ' . ($peserta->rw ?? '-') . ', Dusun: ' . ($peserta->dusun ?? '-') . ', Kelurahan: ' . ($peserta->kelurahan ?? '-') . ', Kecamatan: ' . ($peserta->kecamatan ?? '-') . ', Kode Pos: ' . ($peserta->kode_pos ?? '-');

                                    $idMTempat = $this->getTempatId($peserta->jenis_tinggal);
                                    $idMAgama = $this->getAgamaId($peserta->agama);

                                    $siswaId = DB::table('dummy_siswa')->insertGetId([
                                          'idPSekolah'    => 1, // dummy
                                          'idPKKode'      => $kelasKodeId,
                                          'idMAgama'      => $idMAgama,
                                          'idPPeriode'    => $sekolah->idPPeriode,
                                          'idMStatus'     => 1,
                                          'nisn'          => $peserta->nisn ?? '-',
                                          'nama'          => $peserta->nama,
                                          'lahir_tanggal' => $peserta->tanggal_lahir,
                                          'lahir_tempat'  => $peserta->tempat_lahir,
                                          'idPPKelas'     => $kelasId,
                                          'idPPStatus'    => 1,
                                          'idMTempat'     => $idMTempat,
                                          'email'         => $peserta->email ?? '-',
                                          'telp'          => $peserta->hp ?? $peserta->telepon ?? '-',
                                          'alamat'        => $alamatLengkap,
                                    ]);
                                    $importResults['import_siswa']['berhasil']++;

                                    // Insert ke siswa_mutasi
                                    DB::table('dummy_siswa_mutasi')->insert([
                                          'idSiswa'       => $siswaId,
                                          'idPKKode'      => $kelasKodeId,
                                          'idPPeriode'    => $sekolah->idPPeriode,
                                          'idMStatus'     => 1,
                                    ]);
                                    $importResults['import_siswa_mutasi']['berhasil']++;

                                    // Insert ke ortu
                                    $idMPekerjaan = $this->getPekerjaanId($peserta->pekerjaan_ayah);
                                    DB::table('dummy_ortu')->insert([
                                          'idPSekolah'    => 1,
                                          'idSiswa'       => $siswaId,
                                          'idMPekerjaan'  => $idMPekerjaan,
                                          'nama'          => $peserta->nama_ayah,
                                          'alamat'        => $alamatLengkap,
                                    ]);
                                    $importResults['import_siswa_ortu']['berhasil']++;
                              }
                        } catch (\Exception $e) {
                              $importResults['import_siswa']['gagal']++;
                              $importResults['import_siswa_mutasi']['gagal']++;
                              $importResults['import_siswa_ortu']['gagal']++;
                        }
                  } catch (\Exception $e) {
                        // Log error umum untuk satu peserta didik
                        error_log($e->getMessage());
                  }
            });

            return response()->json($importResults);
      }

      private function getTempatId($jenisTinggal)
      {
          $tempatMapping = [
              'Bersama orang tua' => 1,
              'Wali'              => 2,
              'Asrama'            => 3,
              'Kost'              => 4,
          ];
  
          return $tempatMapping[$jenisTinggal] ?? 1;
      }
  
      private function getAgamaId($agama)
      {
          $agamaMapping = [
              'Islam'     => 1,
              'Kristen'   => 2,
              'Budha'     => 3,
              'Konghucu'  => 4,
              'Katolik'   => 5,
              'Hindu'     => 6,
              'Lainnya'   => 0
          ];
  
          return $agamaMapping[$agama] ?? 0;
      }
  
      private function getPekerjaanId($pekerjaan)
      {
          $pekerjaanMapping = [
              'Guru'          => 1,
              'Dosen'         => 2,
              'PNS/TNI/POLRI' => 3,
              'BUMN'          => 4,
              'Swasta'        => 5,
              'Wiraswasta'    => 6,
          ];
  
          if (!isset($pekerjaanMapping[$pekerjaan])) {
              $idPekerjaan = DB::table('master_pekerjaan')->insertGetId([
                  'nama' => $pekerjaan,
              ]);
              return $idPekerjaan;
          }
  
          return $pekerjaanMapping[$pekerjaan];
      }
}
