<?php

namespace App\Libraries\ShouldQueue;

use App\Imports\ImportDapodikGuru;
use App\Imports\ImportDapodikSiswa;
use App\Jobs\ImportDataJob;
use App\Models\Import\DapodikSiswaModel;
use App\Models\ImportDapodik\ImportDapodikGuruModel;
use App\Models\ImportDapodik\ImportDapodikSiswaModel;
use App\Models\ImportDapodik\ImportExcelGuruModel;
use App\Models\ImportDapodik\ImportExcelSiswaModel;
use App\Models\Perpus\SekolahModel;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Maatwebsite\Excel\Facades\Excel;

class ImportTransaksi
{
      public static function isNewTeacher($nip, $name)
      {
            $result     = [];
            $newTeacher = true;
            $newMsg     = 'NIP Belum ada !';
            $status     = 1;
            $status_user = 1;

            $isGuru = ImportDapodikGuruModel::where('nip', $nip)->first();
            if (isset($isGuru)) {
                  // $newTeacher = false;
                  $newMsg     = "Data dengan NIP " . $nip . " sudah ada !";
                  $status     = 2;
            }

            if (!is_numeric($nip) || $nip == null || strlen($nip) < 10) {
                  $newTeacher = false;
                  $newMsg = "Data dengan NIP " . $nip . " bukan numeric, data kosong atau nip kurang dari 10 !";
                  $status = 0;
                  $status_user = 0;
            }

            $result = [
                  'newTeacher'      => $newTeacher,
                  'newMsg'          => $newMsg,
                  'name'            => $name,
                  'status'          => $status,
                  'status_user'     => $status_user
            ];

            return $result;
      }

      public static function isNewStudent($nisn, $nipd)
      {
            $result = [];
            $newStudent = true;
            $newMsg = 'NISN Belum ada !';
            $status     = 1;
            $status_user = 1;

            $isStudent = ImportDapodikSiswaModel::where('nisn', $nisn)
                  ->orWhere('nipd')
                  // ->where('idMStatus', 1)
                  ->first();

            if (isset($isStudent)) {
                  $newMsg     = "Data dengan NISN " . $nisn . " atau NIPD " . $nipd . " sudah ada !";
                  $status     = 2;
            }

            $result = [
                  'newStudent'      => $newStudent,
                  'newMsg'          => $newMsg,
                  'status'          => $status,
                  'status_user'     => $status_user
            ];

            return $result;
      }

      public static function importGuru($data)
      {
            Excel::import(new ImportDapodikGuru($data), $data['file_path']);
      }

      public static function importGuruSplit($data)
      {
            $isNewTeacher = self::isNewTeacher($data['nip'], $data['nama']);

            $dataArray = [
                  'idUser' => $data['idUser'],
                  'idPSekolah' => $data['idPSekolah'],
                  'idPPeriode' => $data['idPPeriode'],
                  'nama' => $data['nama'],
                  'nuptk' => $data['nuptk'],
                  'jk' => $data['jk'],
                  'tempat_lahir' => $data['tempat_lahir'],
                  'tanggal_lahir' => $data['tanggal_lahir'],
                  'nip' => $data['nip'],
                  'status_kepegawaian' => $data['status_kepegawaian'],
                  'jenis_ptk' => $data['jenis_ptk'],
                  'agama' => $data['agama'],
                  'alamat_jalan' => $data['alamat_jalan'],
                  'rt' => $data['rt'],
                  'rw' => $data['rw'],
                  'nama_dusun' => $data['nama_dusun'],
                  'desa_kelurahan' => $data['desakelurahan'],  // Assuming 'desakelurahan' matches 'desa_kelurahan'
                  'kecamatan' => $data['kecamatan'],
                  'kode_pos' => $data['kode_pos'],
                  'telepon' => $data['telepon'],
                  'hp' => $data['hp'],
                  'email' => $data['email'],
                  'tugas_tambahan' => $data['tugas_tambahan'],
                  'sk_cpns' => $data['sk_cpns'],
                  'tanggal_cpns' => $data['tanggal_cpns'],
                  'sk_pengangkatan' => $data['sk_pengangkatan'],
                  'tmt_pengangkatan' => $data['tmt_pengangkatan'],
                  'lembaga_pengangkatan' => $data['lembaga_pengangkatan'],
                  'pangkat_golongan' => $data['pangkat_golongan'],
                  'sumber_gaji' => $data['sumber_gaji'],
                  'nama_ibu_kandung' => $data['nama_ibu_kandung'],
                  'status_perkawinan' => $data['status_perkawinan'],
                  'nama_suami_istri' => $data['nama_suamiistri'],  // Assuming 'nama_suamiistri' matches 'nama_suami_istri'
                  'nip_suami_istri' => $data['nip_suamiistri'],  // Assuming 'nip_suamiistri' matches 'nip_suami_istri'
                  'pekerjaan_suami_istri' => $data['pekerjaan_suamiistri'],  // Assuming 'pekerjaan_suamiistri' matches 'pekerjaan_suami_istri'
                  'tmt_pns' => $data['tmt_pns'],
                  'sudah_lisensi_kepala_sekolah' => $data['sudah_lisensi_kepala_sekolah'],
                  'pernah_diklat_kepengawasan' => $data['pernah_diklat_kepengawasan'],
                  'keahlian_braille' => $data['keahlian_braille'],
                  'keahlian_bahasa_isyarat' => $data['keahlian_bahasa_isyarat'],
                  'npwp' => $data['npwp'],
                  'nama_wajib_pajak' => $data['nama_wajib_pajak'],
                  'kewarganegaraan' => $data['kewarganegaraan'],
                  'bank' => $data['bank'],
                  'nomor_rekening_bank' => $data['nomor_rekening_bank'],
                  'rekening_atas_nama' => $data['rekening_atas_nama'],
                  'nik' => $data['nik'],
                  'no_kk' => $data['no_kk'],
                  'karpeg' => $data['karpeg'],
                  'karis_karsu' => $data['kariskarsu'],
                  'lintang' => $data['lintang'],
                  'bujur' => $data['bujur'],
                  'nuks' => $data['nuks'],
                  'status' => $isNewTeacher['status_user']
            ];

            if ($isNewTeacher['newTeacher']) {
                  DB::beginTransaction();
                  try {
                        if ($isNewTeacher['status'] == 2) {
                              ImportDapodikGuruModel::where('nip', $data['nip'])->update($dataArray);
                        } else {
                              ImportDapodikGuruModel::create($dataArray);
                        }
                        DB::commit();
                  } catch (\Exception $e) {
                        DB::rollBack();
                        throw $e;
                  }
            }

            $recordImport = [
                  'idUser'        => $data['idUser'],
                  'idPSekolah'    => $data['idPSekolah'],
                  'idPPeriode'    => $data['idPPeriode'],
                  'nip'           => $data['nip'],
                  'nama'          => $data['nama'],
                  'status'        => $isNewTeacher['status'],
                  'msg'           => $isNewTeacher['newMsg']
            ];

            ImportExcelGuruModel::create($recordImport);
      }

      public static function importSiswa($data)
      {
            Excel::import(new ImportDapodikSiswa($data), $data['file_path']);
      }

      public static function importSiswaSplit($data)
      {
            $isNewStudent = self::isNewStudent($data['nisn'], $data['nipd']);

            $dataArray = [
                  'idUser' => $data['idUser'],
                  'idPSekolah' => $data['idPSekolah'],
                  'idPPeriode' => $data['idPPeriode'],
                  'idPKKode' => $data['idPKKode'],
                  'idMStatus' => $data['idMStatus'],
                  'idPPKelas' => $data['idPPKelas'],
                  'idPPStatus' => $data['idPPStatus'],
                  'nama' => $data['nama'],
                  'nipd' => $data['nipd'],
                  'jk' => $data['jk'],
                  'nisn' => $data['nisn'],
                  'tempat_lahir' => $data['tempat_lahir'],
                  'tanggal_lahir' => $data['tanggal_lahir'],
                  'nik' => $data['nik'],
                  'agama' => $data['agama'],
                  'alamat' => $data['alamat'],
                  'rt' => $data['rt'],
                  'rw' => $data['rw'],
                  'dusun' => $data['dusun'],
                  'kelurahan' => $data['kelurahan'],
                  'kecamatan' => $data['kecamatan'],
                  'kode_pos' => $data['kode_pos'],
                  'jenis_tinggal' => $data['jenis_tinggal'],
                  'alat_transportasi' => $data['alat_transportasi'],
                  'telepon' => $data['telepon'],
                  'hp' => $data['hp'],
                  'email' => $data['e_mail'],
                  'skhun' => $data['skhun'],
                  'penerima_kps' => $data['penerima_kps'],
                  'no_kps' => $data['no_kps'],

                  // Data Ayah
                  'nama_ayah' => $data['data_ayah'],
                  'tahun_lahir_ayah' => $data[25],
                  'jenjang_pendidikan_ayah' => $data[26],
                  'pekerjaan_ayah' => $data[27],
                  'penghasilan_ayah' => $data[28],
                  'nik_ayah' => $data[29],

                  // Data Ibu
                  'nama_ibu' => $data['data_ibu'],
                  'tahun_lahir_ibu' => $data[31],
                  'jenjang_pendidikan_ibu' => $data[32],
                  'pekerjaan_ibu' => $data[33],
                  'penghasilan_ibu' => $data[34],
                  'nik_ibu' => $data[35],

                  // Data Wali
                  'nama_wali' => $data['data_wali'],
                  'tahun_lahir_wali' => $data[37],
                  'jenjang_pendidikan_wali' => $data[38],
                  'pekerjaan_wali' => $data[39],
                  'penghasilan_wali' => $data[40],
                  'nik_wali' => $data[41],

                  'rombel_saat_ini' => $data['rombel_saat_ini'],
                  'no_peserta_un' => $data['no_peserta_ujian_nasional'],
                  'no_seri_ijazah' => $data['no_seri_ijazah'],
                  'penerima_kip' => $data['penerima_kip'],
                  'nomor_kip' => $data['nomor_kip'],
                  'nama_di_kip' => $data['nama_di_kip'],
                  'nomor_kks' => $data['nomor_kks'],
                  'no_registrasi_akta_lahir' => $data['no_registrasi_akta_lahir'],
                  'bank' => $data['bank'],
                  'nomor_rekening_bank' => $data['nomor_rekening_bank'],
                  'rekening_atas_nama' => $data['rekening_atas_nama'],
                  'layak_pip' => $data['layak_pip_usulan_dari_sekolah'],
                  'alasan_layak_pip' => $data['alasan_layak_pip'],
                  'kebutuhan_khusus' => $data['kebutuhan_khusus'],
                  'sekolah_asal' => $data['sekolah_asal'],
                  'anak_keberapa' => $data['anak_ke_berapa'],
                  'lintang' => $data['lintang'],
                  'bujur' => $data['bujur'],
                  'no_kk' => $data['no_kk'],
                  'berat_badan' => $data['berat_badan'],
                  'tinggi_badan' => $data['tinggi_badan'],
                  'lingkar_kepala' => $data['lingkar_kepala'],
                  'jml_saudara_kandung' => $data['jml_saudara_kandung'],
                  'jarak_rumah_ke_sekolah_km' => $data['jarak_rumah_ke_sekolah_km'],
                  'status' => $isNewStudent['status_user']
            ];

            if ($isNewStudent) {
                  DB::beginTransaction();
                  try {
                        if ($isNewStudent['status'] == 2) {
                              ImportDapodikSiswaModel::where('nisn', $data['nisn'])->update($dataArray);
                        } else {
                              ImportDapodikSiswaModel::create($dataArray);
                        }
                        DB::commit();
                  } catch (\Exception $e) {
                        DB::rollBack();
                        throw $e;
                  }
            }

            $recordImport = [
                  'idUser'        => $data['idUser'],
                  'idPSekolah'    => $data['idPSekolah'],
                  'idPPeriode'    => $data['idPPeriode'],
                  'nama'          => $data['nama'],
                  'nisn'          => $data['nisn'],
                  'nipd'          => $data['nipd'],
                  'status'        => $isNewStudent['status'],
                  'msg'           => $isNewStudent['newMsg']
            ];

            ImportExcelSiswaModel::create($recordImport);
      }

      public static function migrasiDapodikGuru($data)
      {
            // $dataPesertaDidik = ImportDapodikSiswaModel::where('idPSekolah', $data['idPSekolah'])
            //                                           ->where('idPPeriode', $data['idPPeriode'])
            //                                           ->get();
            $dataGuru = ImportDapodikGuruModel::where('idPSekolah', $data['idPSekolah'])
                  ->where('idPPeriode', $data['idPPeriode'])
                  ->get();

            $dataJob = [];
            $dataJob['jenis'] = 'migrasiDapodikGuruSplit';
            foreach ($dataGuru as $row) {
                  $dataJob['data']  = $row;
                  ImportDataJob::dispatch($dataJob);
            }
      }

      public static function migrasiDapodikGuruSplit($data)
      {
            // $existingGuru = GuruModel::where('nip', $guru->nip)->first();
            $existingGuru = DB::table('sekolah_guru')->where('nip', $data['data']->nip)->first();


            if ($data['data']->jenis_ptk == 'Guru Mapel') {
                  if (!$existingGuru) {
                        try {
                              DB::table('sekolah_guru')->insert([
                                    'idPSekolah'    => $data['data']->idPSekolah, // dummy
                                    'idMapel'       => 99,
                                    'nip'           => $data['data']->nip ?? '-',
                                    'nama'          => $data['data']->nama,
                                    'telp'          => $data['data']->hp ?? '-',
                                    'email'         => $data['data']->email ?? '-',
                                    'status'        => 1,
                              ]);

                              // $importResults['guru_mapel']['berhasil']++;
                        } catch (\Exception $e) {
                              // $importResults['guru_mapel']['gagal']++;
                        }
                  } else {
                        // $importResults['guru_mapel']['gagal']++;
                  }
            } elseif ($data['data']->jenis_ptk == 'Guru BK') {
                  if (!$existingGuru) {
                        try {
                              $guruImport = DB::table('sekolah_guru')->insertGetId([
                                    'idPSekolah'    => $data['data']->idPSekolah, // dummy
                                    'idMapel'       => 99,
                                    'nip'           => $data['data']->nip ?? '-',
                                    'telp'          => $data['data']->hp ?? '-',
                                    'email'         => $data['data']->email ?? '-',
                                    'status'        => 1,
                              ]);

                              $konselorImport = DB::table('sekolah_konselor')->insertGetId([
                                    'idPSekolah'    => $data['data']->idPSekolah, // dummy
                                    'idSGuru'       => $guruImport,
                                    'status'        => 1,
                              ]);

                              $sekolah = SekolahModel::where('id', 1)->first();

                              DB::table('users')->insert([
                                    'username'      => $data['data']->email,
                                    'password'      => bcrypt("bkpeduli"),
                                    'sandi'         => "bkpeduli", // dummy
                                    'status'        => 1,
                                    'idPSekolah'    => $data['data']->idPSekolah, // dummy
                                    'role'          => 3, // konselor
                                    'idSKonselor'   => $konselorImport,
                                    'idPPeriode'    => $sekolah->idPPeriode,
                                    'telp'          => $data['data']->hp ?? '-',
                              ]);

                              // $importResults['guru_bk']['berhasil']++;
                        } catch (\Exception $e) {
                              // $importResults['guru_bk']['gagal']++;
                        }
                  } else {
                        // $importResults['guru_bk']['gagal']++;
                  }
            }
      }

      public static function migrasiDapodikSiswa($data)
      {
            $dataPesertaDidik = ImportDapodikSiswaModel::where('idPSekolah', $data['idPSekolah'])
                  ->where('idPPeriode', $data['idPPeriode'])
                  // ->limit(100)
                  ->get();

            $dataJob = [];
            $dataJob['jenis'] = 'migrasiDapodikSiswaSplit';
            foreach ($dataPesertaDidik as $row) {
                  $dataJob['data']  = $row;
                  ImportDataJob::dispatch($dataJob);
            }
      }

      public static function migrasiDapodikSiswaSplit($data)
      {
            $sekolah = DB::table('perpus_sekolah')->where('id', $data['data']->idPSekolah)->first(); // dummy 1 diganti id sekolah

            try {
                  // Pastikan kolom rombel_saat_ini valid
                  if (!$data['data']->rombel_saat_ini) {
                        throw new \Exception("Rombel tidak ditemukan");
                  }

                  list($kelas, $jurusan, $kodeKelas) = explode('-', $data['data']->rombel_saat_ini);

                  // Pengecekan jurusan di sekolah
                  try {
                        // $jurusanId = DB::table('perpus_jurusan')->where('idPSekolah', $data['data']->idPSekolah)->where('nama', $jurusan)->value('id');
                        $jurusanId = DB::table('perpus_jurusan')->where([
                              ['idPSekolah', '=', $data['data']->idPSekolah],
                              ['nama', '=', $jurusan],
                        ])->value('id');
                        if (!$jurusanId) {
                              $jurusanId = DB::table('perpus_jurusan')->insertGetId([
                                    'idPSekolah'    => $data['data']->idPSekolah, // dummy
                                    'nama'          => $jurusan,
                              ]);
                              //   $importResults['import_jurusan']['berhasil']++;
                        }
                  } catch (\Exception $e) {
                        echo json_encode($e);
                        die;
                        //     $importResults['import_jurusan']['gagal']++;
                  }

                  // Pengecekan tingkat/kelas di sekolah, jurusan
                  try {
                        // $kelasId = DB::table('perpus_kelas')->where('idPSekolah', $data['data']->idPSekolah)->where('idPJurusan', $jurusanId)->where('nama', $kelas)->value('id');
                        $kelasId = DB::table('perpus_kelas')->where([
                              ['idPSekolah', '=', $data['data']->idPSekolah],
                              ['idPJurusan', '=', $jurusanId],
                              ['nama', '=', $kelas],
                        ])->value('id');
                        if (!$kelasId) {
                              $kelasId = DB::table('perpus_kelas')->insertGetId([
                                    'idPSekolah'    => $data['data']->idPSekolah, // dummy
                                    'idPJurusan'    => $jurusanId,
                                    'nama'          => $kelas,
                              ]);
                              //   $importResults['import_tingkat']['berhasil']++;
                        }
                  } catch (\Exception $e) {
                        echo json_encode($e);
                        die;
                        //     $importResults['import_tingkat']['gagal']++;
                  }

                  // Pengecekan kode kelas di sekolah, jurusan, kelas
                  try {
                        $kelasKodeId = DB::table('perpus_kelasKode')->where([
                              ['idPSekolah', '=', $data['data']->idPSekolah], // dummy
                              ['idPJurusan', '=', $jurusanId],
                              ['idPKelas', '=', $kelasId],
                              ['nama', '=', $kodeKelas],
                        ])->value('id');
                        if (!$kelasKodeId) {
                              $kelasKodeId = DB::table('perpus_kelasKode')->insertGetId([
                                    'idPSekolah'    => $data['data']->idPSekolah, // dummy
                                    'idPJurusan'    => $jurusanId,
                                    'idPKelas'      => $kelasId,
                                    'nama'          => $kodeKelas,
                              ]);
                              //   $importResults['import_index']['berhasil']++;
                        }
                  } catch (\Exception $e) {
                        echo json_encode($e);
                        die;
                        //     $importResults['import_index']['gagal']++;
                  }

                  // Cek apakah siswa sudah ada
                  try {
                        $existingSiswa = DB::table('siswa')->where('nisn', $data['data']->nisn)->first();

                        if (!$existingSiswa) {

                              $alamatLengkap = $data['data']->alamat . ', RT: ' . ($data['data']->rt ?? '-') . ', RW: ' . ($data['data']->rw ?? '-') . ', Dusun: ' . ($data['data']->dusun ?? '-') . ', Kelurahan: ' . ($data['data']->kelurahan ?? '-') . ', Kecamatan: ' . ($data['data']->kecamatan ?? '-') . ', Kode Pos: ' . ($data['data']->kode_pos ?? '-');

                              $idMTempat = self::getTempatId($data['data']->jenis_tinggal);
                              $idMAgama = self::getAgamaId($data['data']->agama);

                              $sisArr = [
                                    'idPSekolah'    => $data['data']->idPSekolah, // dummy
                                    'idPKKode'      => $kelasKodeId,
                                    'idMAgama'      => $idMAgama,
                                    'idPPeriode'    => $sekolah->idPPeriode,
                                    'idMStatus'     => 1,
                                    'nisn'          => $data['data']->nisn ?? '-',
                                    'nama'          => $data['data']->nama,
                                    'lahir_tanggal' => $data['data']->tanggal_lahir,
                                    'lahir_tempat'  => $data['data']->tempat_lahir,
                                    'idPPKelas'     => 1,
                                    'idPPStatus'    => 1,
                                    'idMTempat'     => $idMTempat,
                                    'email'         => $data['data']->email ?? '-',
                                    'telp'          => $data['data']->hp ?? $data['data']->telepon ?? '-',
                                    'alamat'        => $alamatLengkap,
                              ];

                              $siswaId = DB::table('siswa')->insertGetId($sisArr);

                              //   $importResults['import_siswa']['berhasil']++;

                              // Insert ke siswa_mutasi
                              DB::table('siswa_mutasi')->insert([
                                    'idSiswa'       => $siswaId,
                                    'idPKKode'      => $kelasKodeId,
                                    'idPPeriode'    => $sekolah->idPPeriode,
                                    'idMStatus'     => 1,
                              ]);
                              //   $importResults['import_siswa_mutasi']['berhasil']++;

                              // Insert ke ortu
                              $idMPekerjaan = self::getPekerjaanId($data['data']->pekerjaan_ayah);
                              DB::table('ortu')->insert([
                                    'idPSekolah'    => $data['data']->idPSekolah,
                                    'idSiswa'       => $siswaId,
                                    'idMPekerjaan'  => $idMPekerjaan,
                                    'nama'          => $data['data']->nama_ayah,
                                    'alamat'        => $alamatLengkap,
                              ]);
                              //   $importResults['import_siswa_ortu']['berhasil']++;
                        }
                  } catch (\Exception $e) {
                        //     $importResults['import_siswa']['gagal']++;
                        //     $importResults['import_siswa_mutasi']['gagal']++;
                        //     $importResults['import_siswa_ortu']['gagal']++;
                  }
            } catch (\Exception $e) {
                  // Log error umum untuk satu data['data'] didik
                  error_log($e->getMessage());
            }
      }

      public static function getTempatId($jenisTinggal)
      {
            $tempatMapping = [
                  'Bersama orang tua' => 1,
                  'Wali'              => 2,
                  'Asrama'            => 3,
                  'Kost'              => 4,
            ];

            return $tempatMapping[$jenisTinggal] ?? 1;
      }

      public static function getAgamaId($agama)
      {
            $agamaMapping = [
                  'Islam'     => 1,
                  'Kristen'   => 2,
                  'Budha'     => 3,
                  'Konghucu'  => 4,
                  'Katolik'   => 5,
                  'Hindu'     => 6,
                  'Lainnya'   => 0
            ];

            return $agamaMapping[$agama] ?? 0;
      }

      public static function getPekerjaanId($pekerjaan)
      {
            $pekerjaanMapping = [
                  'Guru'          => 1,
                  'Dosen'         => 2,
                  'PNS/TNI/POLRI' => 3,
                  'BUMN'          => 4,
                  'Swasta'        => 5,
                  'Wiraswasta'    => 6,
            ];

            if (!isset($pekerjaanMapping[$pekerjaan])) {
                  $idPekerjaan = DB::table('master_pekerjaan')->insertGetId([
                        'nama' => $pekerjaan,
                  ]);
                  return $idPekerjaan;
            }

            return $pekerjaanMapping[$pekerjaan];
      }
}
